/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.aas.mongodb;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import org.eclipse.basyx.components.configuration.BaSyxMongoDBConfiguration;
import org.eclipse.basyx.submodel.aggregator.SubmodelAggregator;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPIFactory;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class MongoDBSubmodelAggregator
extends SubmodelAggregator {
    private String smCollection;
    private MongoTemplate mongoOps;

    @Deprecated
    public MongoDBSubmodelAggregator(ISubmodelAPIFactory smApiFactory, BaSyxMongoDBConfiguration config) {
        this(smApiFactory, config, MongoClients.create((String)config.getConnectionUrl()));
    }

    public MongoDBSubmodelAggregator(ISubmodelAPIFactory smApiFactory, BaSyxMongoDBConfiguration config, MongoClient client) {
        super(smApiFactory);
        this.smCollection = config.getSubmodelCollection();
        this.mongoOps = new MongoTemplate(client, config.getDatabase());
    }

    public void deleteSubmodelByIdentifier(IIdentifier identifier) {
        super.deleteSubmodelByIdentifier(identifier);
        this.deleteSubmodelFromDB(identifier);
    }

    public void deleteSubmodelByIdShort(String idShort) {
        try {
            ISubmodel sm = this.getSubmodelbyIdShort(idShort);
            super.deleteSubmodelByIdShort(idShort);
            this.deleteSubmodelFromDB(sm.getIdentification());
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            // empty catch block
        }
    }

    private void deleteSubmodelFromDB(IIdentifier identifier) {
        Query hasId = Query.query((CriteriaDefinition)Criteria.where((String)"identification.id").is((Object)identifier.getId()));
        this.mongoOps.remove(hasId, this.smCollection);
    }
}

