/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.types.common;

import de.iip_ecosphere.platform.support.StringUtils;
import de.iip_ecosphere.platform.support.aas.BlobDataElement;
import de.iip_ecosphere.platform.support.aas.DataElement;
import de.iip_ecosphere.platform.support.aas.ElementsAccess;
import de.iip_ecosphere.platform.support.aas.FileDataElement;
import de.iip_ecosphere.platform.support.aas.LangString;
import de.iip_ecosphere.platform.support.aas.MultiLanguageProperty;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.Range;
import de.iip_ecosphere.platform.support.aas.ReferenceElement;
import de.iip_ecosphere.platform.support.aas.RelationshipElement;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElement;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.SubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.aas.Type;
import de.iip_ecosphere.platform.support.aas.types.common.EnumRegistry;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class Utils {
    public static String getCountingIdShort(String prefix, int nr) {
        return prefix + String.format("%02d", nr);
    }

    public static void assertThat(boolean valid, String exception, Object ... args) {
        if (!valid) {
            String tmp = exception;
            for (Object a : args) {
                tmp = StringUtils.replaceOnce((String)tmp, (String)"{}", (String)(null == a ? "null" : a.toString()));
            }
            throw new IllegalArgumentException(tmp);
        }
    }

    public static <B extends SubmodelElementContainerBuilder> B createMultiLanguageProperty(B builder, boolean enable, String idShort, String semanticId, LangString ... texts) {
        if (enable) {
            MultiLanguageProperty.MultiLanguagePropertyBuilder mlpb = builder.createMultiLanguagePropertyBuilder(idShort).setSemanticId(semanticId);
            for (LangString t : texts) {
                mlpb.addText(t);
            }
            mlpb.build();
        }
        return builder;
    }

    public static XMLGregorianCalendar parseCalendar(String date) {
        XMLGregorianCalendar result = null;
        if (null == date) {
            try {
                GregorianCalendar now = new GregorianCalendar();
                result = DatatypeFactory.newInstance().newXMLGregorianCalendar(now);
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {}
        } else {
            try {
                result = DatatypeFactory.newInstance().newXMLGregorianCalendar(date);
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                // empty catch block
            }
        }
        return result;
    }

    public static Date parseDate(String date) {
        return Utils.parseCalendar(date).toGregorianCalendar().getTime();
    }

    public static <T extends SubmodelElementCollection> T wrapSubmodelElementCollection(Submodel submodel, String idShort, Function<SubmodelElementCollection, T> constructor) {
        SubmodelElementCollection sme = submodel.getSubmodelElementCollection(idShort);
        return (T)(null == sme ? null : (SubmodelElementCollection)constructor.apply(sme));
    }

    public static <T extends SubmodelElementCollection> T wrapSubmodelElementCollection(SubmodelElementCollection collection, String idShort, Function<SubmodelElementCollection, T> constructor) {
        SubmodelElementCollection sme = collection.getSubmodelElementCollection(idShort);
        return (T)(null == sme ? null : (SubmodelElementCollection)constructor.apply(sme));
    }

    public static <T extends SubmodelElement> Stream<T> stream(Iterable<SubmodelElement> iterable, Class<T> type, Predicate<T> filter) {
        Predicate<SubmodelElement> typeFilter = null == type ? e -> true : e -> type.isInstance(e);
        ArrayList<SubmodelElement> tmp = new ArrayList<SubmodelElement>();
        for (SubmodelElement e2 : iterable) {
            SubmodelElement t;
            if (!typeFilter.test(e2) || !filter.test(t = (SubmodelElement)type.cast(e2))) continue;
            tmp.add(t);
        }
        return tmp.stream();
    }

    public static <E extends SubmodelElement> Iterable<E> collect(Iterable<SubmodelElement> elements, Class<E> eltCls, String semanticId) {
        return Utils.collect(elements, eltCls, semanticId, e -> e);
    }

    public static <T, E extends SubmodelElement> Iterable<T> collect(Iterable<SubmodelElement> elements, Class<E> eltCls, String semanticId, Function<E, T> translate) {
        return Utils.stream(elements, eltCls, e -> semanticId.equals(e.getSemanticId())).map(e -> translate.apply(e)).collect(Collectors.toList());
    }

    public static <T> T cast(Property prop, Class<T> cls) {
        T result = null;
        try {
            Object v = prop.getValue();
            if (cls.isInstance(v)) {
                result = cls.cast(v);
            }
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return result;
    }

    public static String getStringValue(ElementsAccess parent, String idShort) throws ExecutionException {
        return Utils.getStringValue(parent.getProperty(idShort));
    }

    public static String getStringValue(Property prop) throws ExecutionException {
        try {
            String result = null;
            if (null != prop) {
                result = (String)prop.getValue();
            }
            return result;
        }
        catch (ClassCastException e) {
            throw new ExecutionException(e.getMessage(), null);
        }
    }

    public static int getIntValue(ElementsAccess parent, String idShort) throws ExecutionException {
        try {
            int result = 0;
            Property prop = parent.getProperty(idShort);
            if (null == prop) {
                throw new ExecutionException("Property " + idShort + " does not exist", null);
            }
            result = (Integer)prop.getValue();
            return result;
        }
        catch (ClassCastException e) {
            throw new ExecutionException(e.getMessage(), null);
        }
    }

    public static double getDoubleValue(ElementsAccess parent, String idShort) throws ExecutionException {
        try {
            double result = 0.0;
            Property prop = parent.getProperty(idShort);
            if (null == prop) {
                throw new ExecutionException("Property " + idShort + " does not exist", null);
            }
            result = (Double)prop.getValue();
            return result;
        }
        catch (ClassCastException e) {
            throw new ExecutionException(e.getMessage(), null);
        }
    }

    public static float getFloatValue(ElementsAccess parent, String idShort) throws ExecutionException {
        try {
            float result = 0.0f;
            Property prop = parent.getProperty(idShort);
            if (null == prop) {
                throw new ExecutionException("Property " + idShort + " does not exist", null);
            }
            result = ((Float)prop.getValue()).floatValue();
            return result;
        }
        catch (ClassCastException e) {
            throw new ExecutionException(e.getMessage(), null);
        }
    }

    public static long getLongValue(ElementsAccess parent, String idShort) throws ExecutionException {
        try {
            long result = 0L;
            Property prop = parent.getProperty(idShort);
            if (null == prop) {
                throw new ExecutionException("Property " + idShort + " does not exist", null);
            }
            result = (Long)prop.getValue();
            return result;
        }
        catch (ClassCastException e) {
            throw new ExecutionException(e.getMessage(), null);
        }
    }

    public static BigInteger getBigIntegerValue(ElementsAccess parent, String idShort) throws ExecutionException {
        try {
            BigInteger result = BigInteger.ZERO;
            Property prop = parent.getProperty(idShort);
            if (null == prop) {
                throw new ExecutionException("Property " + idShort + " does not exist", null);
            }
            result = (BigInteger)prop.getValue();
            return result;
        }
        catch (ClassCastException e) {
            throw new ExecutionException(e.getMessage(), null);
        }
    }

    public static boolean getBooleanValue(ElementsAccess parent, String idShort) throws ExecutionException {
        try {
            boolean result = false;
            Property prop = parent.getProperty(idShort);
            if (null == prop) {
                throw new ExecutionException("Property " + idShort + " does not exist", null);
            }
            result = (Boolean)prop.getValue();
            return result;
        }
        catch (ClassCastException e) {
            throw new ExecutionException(e.getMessage(), null);
        }
    }

    public static Date getDateValue(ElementsAccess parent, String idShort) throws ExecutionException {
        try {
            Date result = null;
            Property prop = parent.getProperty(idShort);
            if (null != prop) {
                Object value = prop.getValue();
                if (value instanceof Date) {
                    result = (Date)value;
                } else if (value instanceof XMLGregorianCalendar) {
                    result = ((XMLGregorianCalendar)value).toGregorianCalendar().getTime();
                } else if (value instanceof Calendar) {
                    result = ((Calendar)value).getTime();
                }
            }
            return result;
        }
        catch (ClassCastException e) {
            throw new ExecutionException(e.getMessage(), null);
        }
    }

    public static String getAnyUriValue(ElementsAccess parent, String idShort) throws ExecutionException {
        return Utils.getStringValue(parent, idShort);
    }

    public static FileDataElement getFileDataElementValue(ElementsAccess parent, String idShort) throws ExecutionException {
        try {
            return (FileDataElement)parent.getDataElement(idShort);
        }
        catch (ClassCastException e) {
            throw new ExecutionException(e.getMessage(), null);
        }
    }

    public static Range getRangeValue(ElementsAccess parent, String idShort) throws ExecutionException {
        try {
            return (Range)parent.getDataElement(idShort);
        }
        catch (ClassCastException e) {
            throw new ExecutionException(e.getMessage(), null);
        }
    }

    public static BlobDataElement getBlobDataElementValue(ElementsAccess parent, String idShort) throws ExecutionException {
        try {
            return (BlobDataElement)parent.getDataElement(idShort);
        }
        catch (ClassCastException e) {
            throw new ExecutionException(e.getMessage(), null);
        }
    }

    public static ReferenceElement getReferenceElementValue(ElementsAccess parent, String idShort) throws ExecutionException {
        return parent.getReferenceElement(idShort);
    }

    public static RelationshipElement getRelationshipElementValue(ElementsAccess parent, String idShort) throws ExecutionException {
        return parent.getRelationshipElement(idShort);
    }

    public static LangString[] getLangStringValue(ElementsAccess parent, String idShort) throws ExecutionException {
        LangString[] result = null;
        DataElement elt = parent.getDataElement(idShort);
        if (elt instanceof MultiLanguageProperty) {
            result = Utils.getLangStringValue((MultiLanguageProperty)elt);
        }
        return result;
    }

    public static LangString[] getLangStringValue(MultiLanguageProperty property) {
        Collection<LangString> ls = property.getDescription().values();
        return ls.toArray(new LangString[ls.size()]);
    }

    public static <T, E extends Enum<E>> T getEnumValue(ElementsAccess parent, String idShort, Class<T> ifCls, Class<E> eCls) throws ExecutionException {
        return Utils.getEnumValue(Utils.getStringValue(parent, idShort), ifCls, eCls);
    }

    public static <T, E extends Enum<E>> T getEnumValue(Property property, Class<T> ifCls, Class<E> eCls) {
        T result;
        try {
            result = Utils.getEnumValue(Utils.getStringValue(property), ifCls, eCls);
        }
        catch (ExecutionException e) {
            result = null;
        }
        return result;
    }

    public static <T, E extends Enum<E>> T getEnumValue(String value, Class<T> ifCls, Class<E> eCls) {
        T result = null;
        value = value.trim().toLowerCase();
        ArrayList<Enum> values = new ArrayList<Enum>();
        for (Class<?> cls : EnumRegistry.getEnums(ifCls, eCls)) {
            for (Field f : cls.getDeclaredFields()) {
                int mod = f.getModifiers();
                if (!cls.isAssignableFrom(f.getType()) || !Modifier.isStatic(mod) || !Modifier.isFinal(mod) || !Modifier.isPublic(mod)) continue;
                try {
                    values.add((Enum)f.get(null));
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            Method[] methods = new Method[]{Utils.getDeclaredMethodSafe(cls, "getValue"), Utils.getDeclaredMethodSafe(cls, "getSemanticId")};
            for (Enum v : values) {
                boolean matches = Utils.matchesEnum(value, v.name().toLowerCase());
                for (Method m : methods) {
                    if (!matches && null != m) {
                        try {
                            matches = Utils.matchesEnum(value, m.invoke((Object)v, new Object[0]));
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                            // empty catch block
                        }
                    }
                    if (matches) break;
                }
                if (!matches) continue;
                if (!ifCls.isInstance(v)) break;
                result = ifCls.cast(v);
                break;
            }
            if (null == result) continue;
            break;
        }
        return result;
    }

    private static Method getDeclaredMethodSafe(Class<?> cls, String name) {
        Method result = null;
        try {
            result = cls.getDeclaredMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return result;
    }

    private static boolean matchesEnum(String value, Object enumValue) {
        boolean matches = false;
        if (enumValue != null) {
            String ev = enumValue.toString().toLowerCase();
            matches = value.equals(ev);
        }
        return matches;
    }

    public static <B extends SubmodelElementCollection.SubmodelElementCollectionBuilder> B createProperty(B builder, String idShort, String semanticId, Type type, Object value) {
        builder.createPropertyBuilder(idShort).setSemanticId(semanticId).setValue(type, value).build();
        return builder;
    }

    public static class GetIterator<T>
    implements Iterator<T> {
        private Function<Integer, T> elementProvider;
        private int pos;
        private T act;

        public GetIterator(Function<Integer, T> elementProvider) {
            this(elementProvider, 0);
        }

        public GetIterator(Function<Integer, T> elementProvider, int pos) {
            this.pos = pos;
            this.elementProvider = elementProvider;
        }

        @Override
        public boolean hasNext() {
            this.act = this.elementProvider.apply(this.pos);
            return this.act != null;
        }

        @Override
        public T next() {
            ++this.pos;
            return this.act;
        }
    }
}

