/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.transport.serialization;

import de.iip_ecosphere.platform.support.json.Json;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslator;
import java.io.IOException;

public class GenericJsonToStringTranslator<T>
implements TypeTranslator<T, String> {
    private Json mapper;
    private Class<T> cls;

    public GenericJsonToStringTranslator(Class<T> cls) {
        this(cls, null);
    }

    public GenericJsonToStringTranslator(Class<T> cls, Json mapper) {
        this.cls = cls;
        if (null == mapper) {
            this.mapper = Json.createInstance4All();
            this.mapper.handleIipDataClasses();
        } else {
            this.mapper = mapper;
        }
    }

    public Json getMapper() {
        return this.mapper;
    }

    @Override
    public T from(String data) throws IOException {
        return (T)this.mapper.readValue(data, this.cls);
    }

    @Override
    public String to(T source) throws IOException {
        return this.mapper.writeValueAsString(source);
    }
}

