/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.bootstrap;

import com.google.common.util.concurrent.SettableFuture;
import com.hivemq.bootstrap.ClientState;
import com.hivemq.configuration.service.entity.Listener;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.client.parameter.ClientInformation;
import com.hivemq.extension.sdk.api.client.parameter.ConnectionInformation;
import com.hivemq.extension.sdk.api.packets.auth.ModifiableDefaultPermissions;
import com.hivemq.extensions.client.ClientAuthenticators;
import com.hivemq.extensions.client.ClientAuthorizers;
import com.hivemq.extensions.client.ClientContextImpl;
import com.hivemq.extensions.client.parameter.ConnectionAttributes;
import com.hivemq.extensions.events.client.parameters.ClientEventListeners;
import com.hivemq.mqtt.message.ProtocolVersion;
import com.hivemq.mqtt.message.connect.CONNECT;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.security.auth.SslClientCertificate;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.util.AttributeKey;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.concurrent.ScheduledFuture;

public interface ClientConnectionContext {
    public static final AttributeKey<ClientConnectionContext> CHANNEL_ATTRIBUTE_NAME = AttributeKey.valueOf((String)"ClientConnectionContext");

    @NotNull
    public static ClientConnectionContext of(@NotNull Channel channel) {
        ClientConnectionContext context = (ClientConnectionContext)channel.attr(CHANNEL_ATTRIBUTE_NAME).get();
        if (context != null) {
            return context;
        }
        throw new IllegalStateException("Channel has no ClientConnectionContext.");
    }

    @NotNull
    public Channel getChannel();

    @NotNull
    public ChannelHandler getPublishFlushHandler();

    @NotNull
    public ClientState getClientState();

    public void proposeClientState(@NotNull ClientState var1);

    @Nullable
    public String getClientId();

    public void setClientId(@NotNull String var1);

    @Nullable
    public ProtocolVersion getProtocolVersion();

    public void setProtocolVersion(@NotNull ProtocolVersion var1);

    @Nullable
    public Long getConnectReceivedTimestamp();

    public void setConnectReceivedTimestamp(@NotNull Long var1);

    public void setCleanStart(boolean var1);

    public boolean isClientIdAssigned();

    public void setClientIdAssigned(boolean var1);

    public void setAuthUsername(@NotNull String var1);

    public void setAuthPassword(byte @NotNull [] var1);

    @Nullable
    public Long getClientSessionExpiryInterval();

    public void setClientSessionExpiryInterval(@NotNull Long var1);

    public void setConnectKeepAlive(@NotNull Integer var1);

    @Nullable
    public Long getMaxPacketSizeSend();

    public void setMaxPacketSizeSend(@NotNull Long var1);

    @NotNull
    public Listener getConnectedListener();

    @Nullable
    public Integer getClientReceiveMaximum();

    @Nullable
    public Long getQueueSizeMaximum();

    public void setClientReceiveMaximum(@NotNull Integer var1);

    public void setQueueSizeMaximum(@Nullable Long var1);

    @Nullable
    public ScheduledFuture<?> getAuthFuture();

    public void setAuthFuture(@Nullable ScheduledFuture<?> var1);

    public void setDisconnectFuture(@NotNull SettableFuture<Void> var1);

    public boolean isRequestResponseInformation();

    public void setRequestResponseInformation(boolean var1);

    @Nullable
    public Boolean getRequestProblemInformation();

    public void setRequestProblemInformation(boolean var1);

    public void setConnectMessage(@Nullable CONNECT var1);

    public @NotNull String @Nullable [] getTopicAliasMapping();

    public void setTopicAliasMapping(@NotNull @NotNull String @NotNull [] var1);

    @Nullable
    public String getAuthMethod();

    public void setAuthMethod(@NotNull String var1);

    @Nullable
    public Mqtt5UserProperties getAuthUserProperties();

    public void setAuthUserProperties(@Nullable Mqtt5UserProperties var1);

    @Nullable
    public ByteBuffer getAuthData();

    public void setSendWill(boolean var1);

    public void setPreventLwt(boolean var1);

    @Nullable
    public SettableFuture<Void> getDisconnectFuture();

    @Nullable
    public CONNECT getAuthConnect();

    public void setAuthConnect(@Nullable CONNECT var1);

    public void setAuthData(@Nullable ByteBuffer var1);

    @Nullable
    public String getAuthCipherSuite();

    public void setAuthCipherSuite(@NotNull String var1);

    @Nullable
    public String getAuthProtocol();

    public void setAuthProtocol(@NotNull String var1);

    @Nullable
    public SslClientCertificate getAuthCertificate();

    public void setAuthCertificate(@NotNull SslClientCertificate var1);

    @Nullable
    public String getAuthSniHostname();

    public void setAuthSniHostname(@NotNull String var1);

    @Nullable
    public ClientContextImpl getExtensionClientContext();

    public void setExtensionClientContext(@NotNull ClientContextImpl var1);

    @Nullable
    public ClientAuthenticators getExtensionClientAuthenticators();

    public void setExtensionClientAuthenticators(@NotNull ClientAuthenticators var1);

    @Nullable
    public ModifiableDefaultPermissions getAuthPermissions();

    public void setAuthPermissions(@NotNull ModifiableDefaultPermissions var1);

    @Nullable
    public ClientInformation getExtensionClientInformation();

    public void setExtensionClientInformation(@NotNull ClientInformation var1);

    @Nullable
    public ConnectionInformation getExtensionConnectionInformation();

    public void setExtensionConnectionInformation(@NotNull ConnectionInformation var1);

    @Nullable
    public ClientAuthorizers getExtensionClientAuthorizers();

    public void setExtensionClientAuthorizers(@NotNull ClientAuthorizers var1);

    @Nullable
    public ClientEventListeners getExtensionClientEventListeners();

    public void setExtensionClientEventListeners(@NotNull ClientEventListeners var1);

    public boolean isIncomingPublishesSkipRest();

    public void setIncomingPublishesSkipRest(boolean var1);

    @Nullable
    public ConnectionAttributes getConnectionAttributes();

    @NotNull
    public ConnectionAttributes setConnectionAttributesIfAbsent(@NotNull ConnectionAttributes var1);

    @NotNull
    public Optional<String> getChannelIP();

    @NotNull
    public Optional<InetAddress> getChannelAddress();
}

