/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.configuration.reader;

import com.google.inject.Inject;
import com.hivemq.configuration.entity.MqttConfigEntity;
import com.hivemq.configuration.entity.mqtt.MqttConfigurationDefaults;
import com.hivemq.configuration.service.MqttConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.mqtt.message.QoS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttConfigurator {
    @NotNull
    private final MqttConfigurationService mqttConfigurationService;
    private static final Logger log = LoggerFactory.getLogger(MqttConfigurator.class);

    @Inject
    public MqttConfigurator(@NotNull MqttConfigurationService mqttConfigurationService) {
        this.mqttConfigurationService = mqttConfigurationService;
    }

    void setMqttConfig(@NotNull MqttConfigEntity mqttConfigEntity) {
        this.mqttConfigurationService.setRetainedMessagesEnabled(mqttConfigEntity.getRetainedMessagesConfigEntity().isEnabled());
        this.mqttConfigurationService.setWildcardSubscriptionsEnabled(mqttConfigEntity.getWildcardSubscriptionsConfigEntity().isEnabled());
        this.mqttConfigurationService.setSubscriptionIdentifierEnabled(mqttConfigEntity.getSubscriptionIdentifierConfigEntity().isEnabled());
        this.mqttConfigurationService.setSharedSubscriptionsEnabled(mqttConfigEntity.getSharedSubscriptionsConfigEntity().isEnabled());
        this.mqttConfigurationService.setMaximumQos(this.validateQoS(mqttConfigEntity.getQoSConfigEntity().getMaxQos()));
        this.mqttConfigurationService.setTopicAliasEnabled(mqttConfigEntity.getTopicAliasConfigEntity().isEnabled());
        this.mqttConfigurationService.setTopicAliasMaxPerClient(this.validateMaxPerClient(mqttConfigEntity.getTopicAliasConfigEntity().getMaxPerClient()));
        this.mqttConfigurationService.setMaxQueuedMessages(mqttConfigEntity.getQueuedMessagesConfigEntity().getMaxQueueSize());
        this.mqttConfigurationService.setQueuedMessagesStrategy(MqttConfigurationService.QueuedMessagesStrategy.valueOf(mqttConfigEntity.getQueuedMessagesConfigEntity().getQueuedMessagesStrategy().name()));
        long clientSessionExpiryInterval = mqttConfigEntity.getSessionExpiryConfigEntity().getMaxInterval();
        this.mqttConfigurationService.setMaxSessionExpiryInterval(this.validateSessionExpiryInterval(clientSessionExpiryInterval));
        long maxMessageExpiryInterval = mqttConfigEntity.getMessageExpiryConfigEntity().getMaxInterval();
        this.mqttConfigurationService.setMaxMessageExpiryInterval(this.validateMessageExpiryInterval(maxMessageExpiryInterval));
        int serverReceiveMaximum = mqttConfigEntity.getReceiveMaximumConfigEntity().getServerReceiveMaximum();
        this.mqttConfigurationService.setServerReceiveMaximum(this.validateServerReceiveMaximum(serverReceiveMaximum));
        int maxKeepAlive = mqttConfigEntity.getKeepAliveConfigEntity().getMaxKeepAlive();
        this.mqttConfigurationService.setKeepAliveMax(this.validateKeepAliveMaximum(maxKeepAlive));
        this.mqttConfigurationService.setKeepAliveAllowZero(mqttConfigEntity.getKeepAliveConfigEntity().isAllowUnlimted());
        int maxPacketSize = mqttConfigEntity.getPacketsConfigEntity().getMaxPacketSize();
        this.mqttConfigurationService.setMaxPacketSize(this.validateMaxPacketSize(maxPacketSize));
    }

    private int validateMaxPerClient(int maxPerClient) {
        if (maxPerClient < 1) {
            log.warn("The configured topic alias maximum per client ({}) is too small. It was set to {} instead.", (Object)maxPerClient, (Object)1);
            return 1;
        }
        if (maxPerClient > 65535) {
            log.warn("The configured topic alias maximum per client ({}) is too large. It was set to {} instead.", (Object)maxPerClient, (Object)65535);
            return 65535;
        }
        return maxPerClient;
    }

    @NotNull
    private QoS validateQoS(int qos) {
        QoS qoS = QoS.valueOf(qos);
        if (qoS != null) {
            return qoS;
        }
        log.warn("The configured maximum qos ({}) does not exist. It was set to ({}) instead.", (Object)qos, (Object)MqttConfigurationDefaults.MAXIMUM_QOS_DEFAULT.getQosNumber());
        return MqttConfigurationDefaults.MAXIMUM_QOS_DEFAULT;
    }

    private long validateMessageExpiryInterval(long maxMessageExpiryInterval) {
        if (maxMessageExpiryInterval <= 0L) {
            log.warn("The configured max message expiry interval ({}) is too short. It was set to {} seconds instead.", (Object)maxMessageExpiryInterval, (Object)0x100000000L);
            return 0x100000000L;
        }
        if (maxMessageExpiryInterval > 0x100000000L) {
            log.warn("The configured max message expiry interval ({}) is too high. It was set to {} seconds instead.", (Object)maxMessageExpiryInterval, (Object)0x100000000L);
            return 0x100000000L;
        }
        return maxMessageExpiryInterval;
    }

    private int validateMaxPacketSize(int maxPacketSize) {
        if (maxPacketSize < 1) {
            log.warn("The configured max packet size ({}) is too short. It was set to {} bytes instead.", (Object)maxPacketSize, (Object)0x10000004);
            return 0x10000004;
        }
        if (maxPacketSize > 0x10000004) {
            log.warn("The configured max packet size ({}) is too high. It was set to {} bytes instead.", (Object)maxPacketSize, (Object)0x10000004);
            return 0x10000004;
        }
        return maxPacketSize;
    }

    private long validateSessionExpiryInterval(long sessionExpiryInterval) {
        if (sessionExpiryInterval < 0L) {
            log.warn("The configured session expiry interval ({}) is too short. It was set to {} seconds instead.", (Object)sessionExpiryInterval, (Object)0L);
            return 0L;
        }
        if (sessionExpiryInterval > 0xFFFFFFFFL) {
            log.warn("The configured session expiry interval ({}) is too high. It was set to {} seconds instead.", (Object)sessionExpiryInterval, (Object)0xFFFFFFFFL);
            return 0xFFFFFFFFL;
        }
        return sessionExpiryInterval;
    }

    private int validateServerReceiveMaximum(int receiveMaximum) {
        if (receiveMaximum < 1) {
            log.warn("The configured server receive maximum ({}) is too short. It was set to {} seconds instead.", (Object)receiveMaximum, (Object)10);
            return 10;
        }
        if (receiveMaximum > 65535) {
            log.warn("The configured server receive maximum ({}) is too high. It was set to {} seconds instead.", (Object)receiveMaximum, (Object)65535);
            return 65535;
        }
        return receiveMaximum;
    }

    private int validateKeepAliveMaximum(int keepAliveMaximum) {
        if (keepAliveMaximum < 1) {
            log.warn("The configured keep alive maximum ({}) is too short. It was set to {} seconds instead.", (Object)keepAliveMaximum, (Object)65535);
            return 65535;
        }
        if (keepAliveMaximum > 65535) {
            log.warn("The configured keep alive maximum ({}) is too high. It was set to {} seconds instead.", (Object)keepAliveMaximum, (Object)65535);
            return 65535;
        }
        return keepAliveMaximum;
    }
}

