/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.configuration.service.entity;

import com.google.common.base.Preconditions;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import java.util.List;

public class Tls {
    @NotNull
    private final String keystorePath;
    @NotNull
    private final String keystorePassword;
    @NotNull
    private final String keystoreType;
    @NotNull
    private final String privateKeyPassword;
    @Nullable
    private final String truststorePath;
    @Nullable
    private final String truststorePassword;
    @Nullable
    private final String truststoreType;
    private final int handshakeTimeout;
    @NotNull
    private final ClientAuthMode clientAuthMode;
    @NotNull
    private final List<String> protocols;
    @NotNull
    private final List<String> cipherSuites;
    @Nullable
    private final Boolean preferServerCipherSuites;

    protected Tls(@NotNull String keystorePath, @NotNull String keystorePassword, @NotNull String keystoreType, @NotNull String privateKeyPassword, @Nullable String truststorePath, @Nullable String truststorePassword, @Nullable String truststoreType, int handshakeTimeout, @NotNull ClientAuthMode clientAuthMode, @NotNull List<String> protocols, @NotNull List<String> cipherSuites, @Nullable Boolean preferServerCipherSuites) {
        Preconditions.checkNotNull((Object)((Object)clientAuthMode), (Object)"clientAuthMode must not be null");
        Preconditions.checkNotNull(protocols, (Object)"protocols must not be null");
        Preconditions.checkNotNull(cipherSuites, (Object)"cipher suites must not be null");
        this.keystorePath = keystorePath;
        this.keystorePassword = keystorePassword;
        this.keystoreType = keystoreType;
        this.privateKeyPassword = privateKeyPassword;
        this.truststorePath = truststorePath;
        this.truststorePassword = truststorePassword;
        this.truststoreType = truststoreType;
        this.handshakeTimeout = handshakeTimeout;
        this.clientAuthMode = clientAuthMode;
        this.protocols = protocols;
        this.cipherSuites = cipherSuites;
        this.preferServerCipherSuites = preferServerCipherSuites;
    }

    @NotNull
    public String getKeystorePath() {
        return this.keystorePath;
    }

    @NotNull
    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    @NotNull
    public String getKeystoreType() {
        return this.keystoreType;
    }

    @NotNull
    public String getPrivateKeyPassword() {
        return this.privateKeyPassword;
    }

    @Nullable
    public String getTruststorePath() {
        return this.truststorePath;
    }

    @Nullable
    public String getTruststorePassword() {
        return this.truststorePassword;
    }

    @Nullable
    public String getTruststoreType() {
        return this.truststoreType;
    }

    public int getHandshakeTimeout() {
        return this.handshakeTimeout;
    }

    @NotNull
    public ClientAuthMode getClientAuthMode() {
        return this.clientAuthMode;
    }

    @NotNull
    public List<String> getProtocols() {
        return this.protocols;
    }

    @NotNull
    public List<String> getCipherSuites() {
        return this.cipherSuites;
    }

    @Nullable
    public Boolean isPreferServerCipherSuites() {
        return this.preferServerCipherSuites;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tls tls = (Tls)o;
        if (!this.keystorePath.equals(tls.keystorePath)) {
            return false;
        }
        if (!this.keystorePassword.equals(tls.keystorePassword)) {
            return false;
        }
        if (!this.keystoreType.equals(tls.keystoreType)) {
            return false;
        }
        if (!this.privateKeyPassword.equals(tls.privateKeyPassword)) {
            return false;
        }
        if (this.truststorePath != null ? !this.truststorePath.equals(tls.truststorePath) : tls.truststorePath != null) {
            return false;
        }
        if (this.truststorePassword != null ? !this.truststorePassword.equals(tls.truststorePassword) : tls.truststorePassword != null) {
            return false;
        }
        if (this.truststoreType != null ? !this.truststoreType.equals(tls.truststoreType) : tls.truststoreType != null) {
            return false;
        }
        if (this.handshakeTimeout != tls.handshakeTimeout) {
            return false;
        }
        if (this.clientAuthMode != tls.clientAuthMode) {
            return false;
        }
        if (!this.protocols.equals(tls.protocols)) {
            return false;
        }
        if (this.preferServerCipherSuites != null ? !this.preferServerCipherSuites.equals(tls.preferServerCipherSuites) : tls.preferServerCipherSuites != null) {
            return false;
        }
        return this.cipherSuites.equals(tls.cipherSuites);
    }

    public int hashCode() {
        int result = this.keystorePath.hashCode();
        result = 31 * result + this.keystorePassword.hashCode();
        result = 31 * result + this.keystoreType.hashCode();
        result = 31 * result + this.privateKeyPassword.hashCode();
        result = 31 * result + (this.truststorePath != null ? this.truststorePath.hashCode() : 0);
        result = 31 * result + (this.truststorePassword != null ? this.truststorePassword.hashCode() : 0);
        result = 31 * result + (this.truststoreType != null ? this.truststoreType.hashCode() : 0);
        result = 31 * result + this.handshakeTimeout;
        result = 31 * result + this.clientAuthMode.hashCode();
        result = 31 * result + this.protocols.hashCode();
        result = 31 * result + this.cipherSuites.hashCode();
        result = 31 * result + (this.preferServerCipherSuites != null ? this.preferServerCipherSuites.hashCode() : 0);
        return result;
    }

    public static class Builder {
        @Nullable
        private String keystorePath;
        @Nullable
        private String keystorePassword;
        @Nullable
        private String keystoreType;
        @Nullable
        private String privateKeyPassword;
        @Nullable
        private String truststorePath;
        @Nullable
        private String truststorePassword;
        @Nullable
        private String truststoreType;
        private int handshakeTimeout;
        @Nullable
        private ClientAuthMode clientAuthMode;
        @Nullable
        private List<String> protocols;
        @Nullable
        private List<String> cipherSuites;
        @Nullable
        private Boolean preferServerCipherSuites;

        @NotNull
        public Builder withKeystorePath(@NotNull String keystorePath) {
            this.keystorePath = keystorePath;
            return this;
        }

        @NotNull
        public Builder withKeystorePassword(@NotNull String keystorePassword) {
            this.keystorePassword = keystorePassword;
            return this;
        }

        @NotNull
        public Builder withKeystoreType(@NotNull String keystoreType) {
            this.keystoreType = keystoreType;
            return this;
        }

        @NotNull
        public Builder withPrivateKeyPassword(@NotNull String privateKeyPassword) {
            this.privateKeyPassword = privateKeyPassword;
            return this;
        }

        @NotNull
        public Builder withTruststorePath(@Nullable String truststorePath) {
            this.truststorePath = truststorePath;
            return this;
        }

        @NotNull
        public Builder withTruststorePassword(@Nullable String truststorePassword) {
            this.truststorePassword = truststorePassword;
            return this;
        }

        @NotNull
        public Builder withTruststoreType(@Nullable String truststoreType) {
            this.truststoreType = truststoreType;
            return this;
        }

        @NotNull
        public Builder withHandshakeTimeout(int handshakeTimeout) {
            this.handshakeTimeout = handshakeTimeout;
            return this;
        }

        @NotNull
        public Builder withClientAuthMode(@NotNull ClientAuthMode clientAuthMode) {
            this.clientAuthMode = clientAuthMode;
            return this;
        }

        @NotNull
        public Builder withProtocols(@NotNull List<String> protocols) {
            this.protocols = protocols;
            return this;
        }

        @NotNull
        public Builder withCipherSuites(@NotNull List<String> cipherSuites) {
            this.cipherSuites = cipherSuites;
            return this;
        }

        @NotNull
        public Builder withPreferServerCipherSuites(@Nullable Boolean preferServerCipherSuites) {
            this.preferServerCipherSuites = preferServerCipherSuites;
            return this;
        }

        @NotNull
        public Tls build() {
            Preconditions.checkNotNull((Object)this.keystorePath, (Object)"keystorePath must not be null");
            Preconditions.checkNotNull((Object)this.keystorePassword, (Object)"keystorePassword must not be null");
            Preconditions.checkNotNull((Object)this.keystoreType, (Object)"keystoreType must not be null");
            Preconditions.checkNotNull((Object)this.privateKeyPassword, (Object)"privateKeyPassword must not be null");
            Preconditions.checkNotNull((Object)((Object)this.clientAuthMode), (Object)"clientAuthMode must not be null");
            Preconditions.checkNotNull(this.protocols, (Object)"protocols must not be null");
            Preconditions.checkNotNull(this.cipherSuites, (Object)"cipher suites must not be null");
            return new Tls(this.keystorePath, this.keystorePassword, this.keystoreType, this.privateKeyPassword, this.truststorePath, this.truststorePassword, this.truststoreType, this.handshakeTimeout, this.clientAuthMode, this.protocols, this.cipherSuites, this.preferServerCipherSuites){};
        }
    }

    public static enum ClientAuthMode {
        NONE("none"),
        OPTIONAL("optional"),
        REQUIRED("required");

        @NotNull
        private final String clientAuthMode;

        private ClientAuthMode(String clientAuthMode) {
            this.clientAuthMode = clientAuthMode;
        }

        @NotNull
        public String toString() {
            return this.clientAuthMode;
        }
    }
}

