/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionUtil {
    private static final Logger log = LoggerFactory.getLogger(ExtensionUtil.class);

    static boolean isValidExtensionFolder(@NotNull Path path, boolean logErrors) {
        Preconditions.checkNotNull((Object)path, (Object)"extension path must not be null");
        File file = path.toFile();
        if (!file.isDirectory()) {
            return false;
        }
        File[] content = file.listFiles();
        if (content == null || content.length < 1) {
            return false;
        }
        boolean xmlPresent = false;
        boolean jarPresent = false;
        for (File subfile : content) {
            String name = subfile.getName();
            if ("hivemq-extension.xml".equals(name)) {
                xmlPresent = true;
            }
            if (!name.endsWith(".jar")) continue;
            jarPresent = true;
        }
        if (xmlPresent && jarPresent) {
            return true;
        }
        if (!xmlPresent) {
            return false;
        }
        if (logErrors) {
            log.warn("Extension folder {} does not contain a .jar file, ignoring extension", (Object)path);
        }
        return false;
    }

    @NotNull
    public static List<Path> findAllExtensionFolders(@NotNull Path extensionPath) throws IOException {
        Preconditions.checkNotNull((Object)extensionPath, (Object)"provided extension folder path CAN NOT be null");
        ImmutableList.Builder builder = ImmutableList.builder();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(extensionPath);){
            for (Path path : stream) {
                if (!ExtensionUtil.isValidExtensionFolder(path, true)) continue;
                log.trace("Found extension folder {}", (Object)path.toString());
                builder.add((Object)path);
            }
        }
        return builder.build();
    }

    public static boolean disableExtensionFolder(@NotNull Path extensionFolderPath) throws IOException {
        File disabledFile = extensionFolderPath.resolve("DISABLED").toFile();
        if (!disabledFile.exists()) {
            return disabledFile.createNewFile();
        }
        return true;
    }
}

