/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.client;

import com.google.common.collect.ImmutableMap;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.auth.Authorizer;
import com.hivemq.extension.sdk.api.auth.PublishAuthorizer;
import com.hivemq.extension.sdk.api.auth.SubscriptionAuthorizer;
import com.hivemq.extensions.ExtensionPriorityComparator;
import com.hivemq.extensions.classloader.IsolatedExtensionClassloader;
import com.hivemq.extensions.client.ClientAuthorizers;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ClientAuthorizersImpl
implements ClientAuthorizers {
    @NotNull
    private final ReadWriteLock authorizerLock;
    @NotNull
    private final Map<String, SubscriptionAuthorizer> subscriptionAuthorizerMap;
    @NotNull
    private final Map<String, PublishAuthorizer> publishAuthorizerMap;

    public ClientAuthorizersImpl(@NotNull ExtensionPriorityComparator extensionPriorityComparator) {
        this.subscriptionAuthorizerMap = new TreeMap<String, SubscriptionAuthorizer>(extensionPriorityComparator);
        this.publishAuthorizerMap = new TreeMap<String, PublishAuthorizer>(extensionPriorityComparator);
        this.authorizerLock = new ReentrantReadWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(@NotNull String pluginId, @NotNull Authorizer authorizer) {
        Lock lock = this.authorizerLock.writeLock();
        lock.lock();
        try {
            if (authorizer instanceof SubscriptionAuthorizer) {
                this.subscriptionAuthorizerMap.put(pluginId, (SubscriptionAuthorizer)authorizer);
            }
            if (authorizer instanceof PublishAuthorizer) {
                this.publishAuthorizerMap.put(pluginId, (PublishAuthorizer)authorizer);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllForPlugin(@NotNull IsolatedExtensionClassloader pluginClassLoader) {
        Lock lock = this.authorizerLock.writeLock();
        lock.lock();
        try {
            ArrayList<String> keysToRemove = new ArrayList<String>();
            for (Map.Entry<String, SubscriptionAuthorizer> entry : this.subscriptionAuthorizerMap.entrySet()) {
                if (!entry.getValue().getClass().getClassLoader().equals(pluginClassLoader)) continue;
                keysToRemove.add(entry.getKey());
            }
            for (String string : keysToRemove) {
                this.subscriptionAuthorizerMap.remove(string);
            }
            keysToRemove.clear();
            for (Map.Entry<String, Object> entry : this.publishAuthorizerMap.entrySet()) {
                if (!((PublishAuthorizer)entry.getValue()).getClass().getClassLoader().equals(pluginClassLoader)) continue;
                keysToRemove.add(entry.getKey());
            }
            for (String string : keysToRemove) {
                this.publishAuthorizerMap.remove(string);
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    @NotNull
    public Map<String, SubscriptionAuthorizer> getSubscriptionAuthorizersMap() {
        Lock lock = this.authorizerLock.readLock();
        lock.lock();
        try {
            ImmutableMap immutableMap = ImmutableMap.copyOf(this.subscriptionAuthorizerMap);
            return immutableMap;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    @NotNull
    public Map<String, PublishAuthorizer> getPublishAuthorizersMap() {
        Lock lock = this.authorizerLock.readLock();
        lock.lock();
        try {
            ImmutableMap immutableMap = ImmutableMap.copyOf(this.publishAuthorizerMap);
            return immutableMap;
        }
        finally {
            lock.unlock();
        }
    }
}

