/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.handler;

import com.google.inject.Inject;
import com.hivemq.bootstrap.ClientConnection;
import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.client.parameter.ClientInformation;
import com.hivemq.extension.sdk.api.client.parameter.ConnectionInformation;
import com.hivemq.extension.sdk.api.interceptor.disconnect.DisconnectInboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.disconnect.DisconnectOutboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.disconnect.parameter.DisconnectInboundInput;
import com.hivemq.extension.sdk.api.interceptor.disconnect.parameter.DisconnectInboundOutput;
import com.hivemq.extension.sdk.api.interceptor.disconnect.parameter.DisconnectOutboundInput;
import com.hivemq.extension.sdk.api.interceptor.disconnect.parameter.DisconnectOutboundOutput;
import com.hivemq.extensions.ExtensionInformationUtil;
import com.hivemq.extensions.HiveMQExtension;
import com.hivemq.extensions.HiveMQExtensions;
import com.hivemq.extensions.client.ClientContextImpl;
import com.hivemq.extensions.executor.PluginOutPutAsyncer;
import com.hivemq.extensions.executor.PluginTaskExecutorService;
import com.hivemq.extensions.executor.task.PluginInOutTask;
import com.hivemq.extensions.executor.task.PluginInOutTaskContext;
import com.hivemq.extensions.handler.ExtensionParameterHolder;
import com.hivemq.extensions.interceptor.disconnect.parameter.DisconnectInboundInputImpl;
import com.hivemq.extensions.interceptor.disconnect.parameter.DisconnectInboundOutputImpl;
import com.hivemq.extensions.interceptor.disconnect.parameter.DisconnectOutboundInputImpl;
import com.hivemq.extensions.interceptor.disconnect.parameter.DisconnectOutboundOutputImpl;
import com.hivemq.extensions.packets.disconnect.DisconnectPacketImpl;
import com.hivemq.extensions.packets.disconnect.ModifiableInboundDisconnectPacketImpl;
import com.hivemq.extensions.packets.disconnect.ModifiableOutboundDisconnectPacketImpl;
import com.hivemq.mqtt.message.disconnect.DISCONNECT;
import com.hivemq.util.Exceptions;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPromise;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DisconnectInterceptorHandler {
    private static final Logger log = LoggerFactory.getLogger(DisconnectInterceptorHandler.class);
    @NotNull
    private final FullConfigurationService configurationService;
    @NotNull
    private final PluginOutPutAsyncer asyncer;
    @NotNull
    private final HiveMQExtensions hiveMQExtensions;
    @NotNull
    private final PluginTaskExecutorService executorService;

    @Inject
    public DisconnectInterceptorHandler(@NotNull FullConfigurationService configurationService, @NotNull PluginOutPutAsyncer asyncer, @NotNull HiveMQExtensions hiveMQExtensions, @NotNull PluginTaskExecutorService executorService) {
        this.configurationService = configurationService;
        this.asyncer = asyncer;
        this.hiveMQExtensions = hiveMQExtensions;
        this.executorService = executorService;
    }

    public void handleInboundDisconnect(@NotNull ChannelHandlerContext ctx, @NotNull DISCONNECT disconnect) {
        Channel channel = ctx.channel();
        ClientConnection clientConnection = ClientConnection.of(channel);
        String clientId = clientConnection.getClientId();
        if (clientId == null) {
            return;
        }
        ClientContextImpl clientContext = clientConnection.getExtensionClientContext();
        if (clientContext == null) {
            ctx.fireChannelRead((Object)disconnect);
            return;
        }
        List<DisconnectInboundInterceptor> interceptors = clientContext.getDisconnectInboundInterceptors();
        if (interceptors.isEmpty()) {
            ctx.fireChannelRead((Object)disconnect);
            return;
        }
        channel.config().setOption(ChannelOption.ALLOW_HALF_CLOSURE, (Object)true);
        ClientInformation clientInfo = ExtensionInformationUtil.getAndSetClientInformation(channel, clientId);
        ConnectionInformation connectionInfo = ExtensionInformationUtil.getAndSetConnectionInformation(channel);
        Long originalSessionExpiryInterval = clientConnection.getClientSessionExpiryInterval();
        DisconnectPacketImpl packet = new DisconnectPacketImpl(disconnect);
        DisconnectInboundInputImpl input = new DisconnectInboundInputImpl(clientInfo, connectionInfo, packet);
        ExtensionParameterHolder<DisconnectInboundInputImpl> inputHolder = new ExtensionParameterHolder<DisconnectInboundInputImpl>(input);
        ModifiableInboundDisconnectPacketImpl modifiablePacket = new ModifiableInboundDisconnectPacketImpl(packet, this.configurationService, originalSessionExpiryInterval);
        DisconnectInboundOutputImpl output = new DisconnectInboundOutputImpl(this.asyncer, modifiablePacket);
        ExtensionParameterHolder<DisconnectInboundOutputImpl> outputHolder = new ExtensionParameterHolder<DisconnectInboundOutputImpl>(output);
        DisconnectInboundInterceptorContext context = new DisconnectInboundInterceptorContext(clientId, interceptors.size(), ctx, inputHolder, outputHolder);
        for (DisconnectInboundInterceptor interceptor : interceptors) {
            HiveMQExtension extension = this.hiveMQExtensions.getExtensionForClassloader(interceptor.getClass().getClassLoader());
            if (extension == null) {
                context.finishInterceptor();
                continue;
            }
            DisconnectInboundInterceptorTask task = new DisconnectInboundInterceptorTask(interceptor, extension.getId());
            this.executorService.handlePluginInOutTaskExecution(context, inputHolder, outputHolder, task);
        }
    }

    public void handleOutboundDisconnect(@NotNull ChannelHandlerContext ctx, @NotNull DISCONNECT disconnect, @NotNull ChannelPromise promise) {
        Channel channel = ctx.channel();
        ClientConnectionContext clientConnectionContext = ClientConnectionContext.of(channel);
        String clientId = clientConnectionContext.getClientId();
        if (clientId == null) {
            return;
        }
        ClientContextImpl clientContext = clientConnectionContext.getExtensionClientContext();
        if (clientContext == null) {
            ctx.write((Object)disconnect, promise);
            return;
        }
        List<DisconnectOutboundInterceptor> interceptors = clientContext.getDisconnectOutboundInterceptors();
        if (interceptors.isEmpty()) {
            ctx.write((Object)disconnect, promise);
            return;
        }
        ClientInformation clientInfo = ExtensionInformationUtil.getAndSetClientInformation(channel, clientId);
        ConnectionInformation connectionInfo = ExtensionInformationUtil.getAndSetConnectionInformation(channel);
        DisconnectPacketImpl packet = new DisconnectPacketImpl(disconnect);
        DisconnectOutboundInputImpl input = new DisconnectOutboundInputImpl(clientInfo, connectionInfo, packet);
        ExtensionParameterHolder<DisconnectOutboundInputImpl> inputHolder = new ExtensionParameterHolder<DisconnectOutboundInputImpl>(input);
        ModifiableOutboundDisconnectPacketImpl modifiablePacket = new ModifiableOutboundDisconnectPacketImpl(packet, this.configurationService);
        DisconnectOutboundOutputImpl output = new DisconnectOutboundOutputImpl(this.asyncer, modifiablePacket);
        ExtensionParameterHolder<DisconnectOutboundOutputImpl> outputHolder = new ExtensionParameterHolder<DisconnectOutboundOutputImpl>(output);
        DisconnectOutboundInterceptorContext context = new DisconnectOutboundInterceptorContext(clientId, interceptors.size(), ctx, promise, inputHolder, outputHolder);
        for (DisconnectOutboundInterceptor interceptor : interceptors) {
            HiveMQExtension extension = this.hiveMQExtensions.getExtensionForClassloader(interceptor.getClass().getClassLoader());
            if (extension == null) {
                context.finishInterceptor();
                continue;
            }
            DisconnectOutboundInterceptorTask task = new DisconnectOutboundInterceptorTask(interceptor, extension.getId());
            this.executorService.handlePluginInOutTaskExecution(context, inputHolder, outputHolder, task);
        }
    }

    private static class DisconnectInboundInterceptorTask
    implements PluginInOutTask<DisconnectInboundInputImpl, DisconnectInboundOutputImpl> {
        @NotNull
        private final DisconnectInboundInterceptor interceptor;
        @NotNull
        private final String extensionId;

        DisconnectInboundInterceptorTask(@NotNull DisconnectInboundInterceptor interceptor, @NotNull String extensionId) {
            this.interceptor = interceptor;
            this.extensionId = extensionId;
        }

        @Override
        @NotNull
        public DisconnectInboundOutputImpl apply(@NotNull DisconnectInboundInputImpl input, @NotNull DisconnectInboundOutputImpl output) {
            try {
                this.interceptor.onInboundDisconnect((DisconnectInboundInput)input, (DisconnectInboundOutput)output);
            }
            catch (Throwable e) {
                log.warn("Uncaught exception was thrown from extension with id \"{}\" on inbound DISCONNECT interception. Extensions are responsible for their own exception handling.", (Object)this.extensionId, (Object)e);
                output.markAsFailed();
                Exceptions.rethrowError(e);
            }
            return output;
        }

        @Override
        @NotNull
        public ClassLoader getPluginClassLoader() {
            return this.interceptor.getClass().getClassLoader();
        }
    }

    private static class DisconnectInboundInterceptorContext
    extends PluginInOutTaskContext<DisconnectInboundOutputImpl>
    implements Runnable {
        private final int interceptorCount;
        @NotNull
        private final AtomicInteger counter;
        @NotNull
        private final ChannelHandlerContext ctx;
        @NotNull
        private final ExtensionParameterHolder<DisconnectInboundInputImpl> inputHolder;
        @NotNull
        private final ExtensionParameterHolder<DisconnectInboundOutputImpl> outputHolder;

        DisconnectInboundInterceptorContext(@NotNull String identifier, int interceptorCount, @NotNull ChannelHandlerContext ctx, @NotNull ExtensionParameterHolder<DisconnectInboundInputImpl> inputHolder, @NotNull ExtensionParameterHolder<DisconnectInboundOutputImpl> outputHolder) {
            super(identifier);
            this.interceptorCount = interceptorCount;
            this.counter = new AtomicInteger(0);
            this.ctx = ctx;
            this.inputHolder = inputHolder;
            this.outputHolder = outputHolder;
        }

        @Override
        public void pluginPost(@NotNull DisconnectInboundOutputImpl output) {
            if (output.isTimedOut()) {
                log.debug("Async timeout on inbound DISCONNECT interception. Discarding changes made by the interceptor.");
            } else if (output.isFailed()) {
                log.debug("Exception on inbound DISCONNECT interception. Discarding changes made by the interceptor.");
            } else if (output.getDisconnectPacket().isModified()) {
                this.inputHolder.set(this.inputHolder.get().update(output));
            }
            if (!this.finishInterceptor()) {
                this.outputHolder.set(output.update(this.inputHolder.get()));
            }
        }

        public boolean finishInterceptor() {
            if (this.counter.incrementAndGet() == this.interceptorCount) {
                this.ctx.executor().execute((Runnable)this);
                return true;
            }
            return false;
        }

        @Override
        public void run() {
            this.ctx.fireChannelRead((Object)DISCONNECT.from(this.inputHolder.get().getDisconnectPacket()));
        }
    }

    private static class DisconnectOutboundInterceptorTask
    implements PluginInOutTask<DisconnectOutboundInputImpl, DisconnectOutboundOutputImpl> {
        @NotNull
        private final DisconnectOutboundInterceptor interceptor;
        @NotNull
        private final String extensionId;

        DisconnectOutboundInterceptorTask(@NotNull DisconnectOutboundInterceptor interceptor, @NotNull String extensionId) {
            this.interceptor = interceptor;
            this.extensionId = extensionId;
        }

        @Override
        @NotNull
        public DisconnectOutboundOutputImpl apply(@NotNull DisconnectOutboundInputImpl input, @NotNull DisconnectOutboundOutputImpl output) {
            try {
                this.interceptor.onOutboundDisconnect((DisconnectOutboundInput)input, (DisconnectOutboundOutput)output);
            }
            catch (Throwable e) {
                log.warn("Uncaught exception was thrown from extension with id \"{}\" on outbound DISCONNECT interception. Extensions are responsible for their own exception handling.", (Object)this.extensionId, (Object)e);
                output.markAsFailed();
                Exceptions.rethrowError(e);
            }
            return output;
        }

        @Override
        @NotNull
        public ClassLoader getPluginClassLoader() {
            return this.interceptor.getClass().getClassLoader();
        }
    }

    private static class DisconnectOutboundInterceptorContext
    extends PluginInOutTaskContext<DisconnectOutboundOutputImpl>
    implements Runnable {
        private final int interceptorCount;
        @NotNull
        private final AtomicInteger counter;
        @NotNull
        private final ChannelHandlerContext ctx;
        @NotNull
        private final ChannelPromise promise;
        @NotNull
        private final ExtensionParameterHolder<DisconnectOutboundInputImpl> inputHolder;
        @NotNull
        private final ExtensionParameterHolder<DisconnectOutboundOutputImpl> outputHolder;

        DisconnectOutboundInterceptorContext(@NotNull String identifier, int interceptorCount, @NotNull ChannelHandlerContext ctx, @NotNull ChannelPromise promise, @NotNull ExtensionParameterHolder<DisconnectOutboundInputImpl> inputHolder, @NotNull ExtensionParameterHolder<DisconnectOutboundOutputImpl> outputHolder) {
            super(identifier);
            this.interceptorCount = interceptorCount;
            this.counter = new AtomicInteger(0);
            this.ctx = ctx;
            this.promise = promise;
            this.inputHolder = inputHolder;
            this.outputHolder = outputHolder;
        }

        @Override
        public void pluginPost(@NotNull DisconnectOutboundOutputImpl output) {
            if (output.isTimedOut()) {
                log.debug("Async timeout on outbound DISCONNECT interception. Discarding changes made by the interceptor.");
            } else if (output.isFailed()) {
                log.debug("Exception on outbound DISCONNECT interception. Discarding changes made by the interceptor.");
            } else if (output.getDisconnectPacket().isModified()) {
                this.inputHolder.set(this.inputHolder.get().update(output));
            }
            if (!this.finishInterceptor()) {
                this.outputHolder.set(output.update(this.inputHolder.get()));
            }
        }

        public boolean finishInterceptor() {
            if (this.counter.incrementAndGet() == this.interceptorCount) {
                this.ctx.executor().execute((Runnable)this);
                return true;
            }
            return false;
        }

        @Override
        public void run() {
            this.ctx.writeAndFlush((Object)DISCONNECT.from(this.inputHolder.get().getDisconnectPacket()), this.promise);
        }
    }
}

