/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.handler;

import com.hivemq.bootstrap.ClientConnection;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.async.TimeoutFallback;
import com.hivemq.extension.sdk.api.client.parameter.ClientInformation;
import com.hivemq.extension.sdk.api.client.parameter.ConnectionInformation;
import com.hivemq.extension.sdk.api.interceptor.publish.PublishOutboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.publish.parameter.PublishOutboundInput;
import com.hivemq.extension.sdk.api.interceptor.publish.parameter.PublishOutboundOutput;
import com.hivemq.extensions.ExtensionInformationUtil;
import com.hivemq.extensions.HiveMQExtension;
import com.hivemq.extensions.HiveMQExtensions;
import com.hivemq.extensions.client.ClientContextImpl;
import com.hivemq.extensions.executor.PluginOutPutAsyncer;
import com.hivemq.extensions.executor.PluginTaskExecutorService;
import com.hivemq.extensions.executor.task.PluginInOutTask;
import com.hivemq.extensions.executor.task.PluginInOutTaskContext;
import com.hivemq.extensions.handler.ExtensionParameterHolder;
import com.hivemq.extensions.interceptor.publish.parameter.PublishOutboundInputImpl;
import com.hivemq.extensions.interceptor.publish.parameter.PublishOutboundOutputImpl;
import com.hivemq.extensions.packets.publish.ModifiableOutboundPublishImpl;
import com.hivemq.extensions.packets.publish.PublishPacketImpl;
import com.hivemq.mqtt.event.PublishDroppedEvent;
import com.hivemq.mqtt.message.dropping.MessageDroppedService;
import com.hivemq.mqtt.message.publish.PUBLISH;
import com.hivemq.mqtt.message.publish.PUBLISHFactory;
import com.hivemq.util.Exceptions;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PublishOutboundInterceptorHandler {
    private static final Logger log = LoggerFactory.getLogger(PublishOutboundInterceptorHandler.class);
    @NotNull
    private final PluginOutPutAsyncer asyncer;
    @NotNull
    private final FullConfigurationService configurationService;
    @NotNull
    private final PluginTaskExecutorService pluginTaskExecutorService;
    @NotNull
    private final HiveMQExtensions hiveMQExtensions;
    @NotNull
    private final MessageDroppedService messageDroppedService;

    @Inject
    public PublishOutboundInterceptorHandler(@NotNull PluginOutPutAsyncer asyncer, @NotNull FullConfigurationService configurationService, @NotNull PluginTaskExecutorService pluginTaskExecutorService, @NotNull HiveMQExtensions hiveMQExtensions, @NotNull MessageDroppedService messageDroppedService) {
        this.asyncer = asyncer;
        this.configurationService = configurationService;
        this.pluginTaskExecutorService = pluginTaskExecutorService;
        this.hiveMQExtensions = hiveMQExtensions;
        this.messageDroppedService = messageDroppedService;
    }

    public void handleOutboundPublish(@NotNull ChannelHandlerContext ctx, @NotNull PUBLISH publish, @NotNull ChannelPromise promise) {
        Channel channel = ctx.channel();
        ClientConnection clientConnection = ClientConnection.of(channel);
        String clientId = clientConnection.getClientId();
        if (clientId == null) {
            return;
        }
        ClientContextImpl clientContext = clientConnection.getExtensionClientContext();
        if (clientContext == null) {
            ctx.write((Object)publish, promise);
            return;
        }
        List<PublishOutboundInterceptor> interceptors = clientContext.getPublishOutboundInterceptors();
        if (interceptors.isEmpty()) {
            ctx.write((Object)publish, promise);
            return;
        }
        ClientInformation clientInfo = ExtensionInformationUtil.getAndSetClientInformation(channel, clientId);
        ConnectionInformation connectionInfo = ExtensionInformationUtil.getAndSetConnectionInformation(channel);
        PublishPacketImpl packet = new PublishPacketImpl(publish);
        PublishOutboundInputImpl input = new PublishOutboundInputImpl(clientInfo, connectionInfo, packet);
        ExtensionParameterHolder<PublishOutboundInputImpl> inputHolder = new ExtensionParameterHolder<PublishOutboundInputImpl>(input);
        ModifiableOutboundPublishImpl modifiablePacket = new ModifiableOutboundPublishImpl(packet, this.configurationService);
        PublishOutboundOutputImpl output = new PublishOutboundOutputImpl(this.asyncer, modifiablePacket);
        ExtensionParameterHolder<PublishOutboundOutputImpl> outputHolder = new ExtensionParameterHolder<PublishOutboundOutputImpl>(output);
        PublishOutboundInterceptorContext context = new PublishOutboundInterceptorContext(clientId, interceptors.size(), ctx, promise, publish, inputHolder, outputHolder, this.messageDroppedService);
        for (PublishOutboundInterceptor interceptor : interceptors) {
            HiveMQExtension extension = this.hiveMQExtensions.getExtensionForClassloader(interceptor.getClass().getClassLoader());
            if (extension == null) {
                context.finishInterceptor();
                continue;
            }
            PublishOutboundInterceptorTask task = new PublishOutboundInterceptorTask(interceptor, extension.getId());
            this.pluginTaskExecutorService.handlePluginInOutTaskExecution(context, inputHolder, outputHolder, task);
        }
    }

    private static class PublishOutboundInterceptorTask
    implements PluginInOutTask<PublishOutboundInputImpl, PublishOutboundOutputImpl> {
        @NotNull
        private final PublishOutboundInterceptor interceptor;
        @NotNull
        private final String extensionId;

        private PublishOutboundInterceptorTask(@NotNull PublishOutboundInterceptor interceptor, @NotNull String extensionId) {
            this.interceptor = interceptor;
            this.extensionId = extensionId;
        }

        @Override
        @NotNull
        public PublishOutboundOutputImpl apply(@NotNull PublishOutboundInputImpl input, @NotNull PublishOutboundOutputImpl output) {
            if (output.isPreventDelivery()) {
                return output;
            }
            try {
                this.interceptor.onOutboundPublish((PublishOutboundInput)input, (PublishOutboundOutput)output);
            }
            catch (Throwable e) {
                log.warn("Uncaught exception was thrown from extension with id \"{}\" on outbound PUBLISH interception. Extensions are responsible for their own exception handling.", (Object)this.extensionId, (Object)e);
                output.forciblyPreventPublishDelivery();
                Exceptions.rethrowError(e);
            }
            return output;
        }

        @Override
        @NotNull
        public ClassLoader getPluginClassLoader() {
            return this.interceptor.getClass().getClassLoader();
        }
    }

    static class PublishOutboundInterceptorContext
    extends PluginInOutTaskContext<PublishOutboundOutputImpl>
    implements Runnable {
        private final int interceptorCount;
        @NotNull
        private final AtomicInteger counter;
        @NotNull
        private final ChannelHandlerContext ctx;
        @NotNull
        private final ChannelPromise promise;
        @NotNull
        private final PUBLISH publish;
        @NotNull
        private final ExtensionParameterHolder<PublishOutboundInputImpl> inputHolder;
        @NotNull
        private final ExtensionParameterHolder<PublishOutboundOutputImpl> outputHolder;
        @NotNull
        private final MessageDroppedService messageDroppedService;

        PublishOutboundInterceptorContext(@NotNull String identifier, int interceptorCount, @NotNull ChannelHandlerContext ctx, @NotNull ChannelPromise promise, @NotNull PUBLISH publish, @NotNull ExtensionParameterHolder<PublishOutboundInputImpl> inputHolder, @NotNull ExtensionParameterHolder<PublishOutboundOutputImpl> outputHolder, @NotNull MessageDroppedService messageDroppedService) {
            super(identifier);
            this.interceptorCount = interceptorCount;
            this.messageDroppedService = messageDroppedService;
            this.counter = new AtomicInteger(0);
            this.ctx = ctx;
            this.promise = promise;
            this.publish = publish;
            this.inputHolder = inputHolder;
            this.outputHolder = outputHolder;
        }

        @Override
        public void pluginPost(@NotNull PublishOutboundOutputImpl output) {
            if (output.isPreventDelivery()) {
                this.finishInterceptor();
            } else if (output.isTimedOut() && output.getTimeoutFallback() == TimeoutFallback.FAILURE) {
                output.forciblyPreventPublishDelivery();
                this.finishInterceptor();
            } else {
                if (output.getPublishPacket().isModified()) {
                    this.inputHolder.set(this.inputHolder.get().update(output));
                }
                if (!this.finishInterceptor()) {
                    this.outputHolder.set(output.update(this.inputHolder.get()));
                }
            }
        }

        public boolean finishInterceptor() {
            if (this.counter.incrementAndGet() == this.interceptorCount) {
                this.ctx.executor().execute((Runnable)this);
                return true;
            }
            return false;
        }

        @Override
        public void run() {
            if (this.outputHolder.get().isPreventDelivery()) {
                this.messageDroppedService.extensionPrevented(this.getIdentifier(), this.publish.getTopic(), this.publish.getQoS().getQosNumber());
                this.promise.setSuccess();
                this.ctx.fireUserEventTriggered((Object)new PublishDroppedEvent(this.publish));
            } else {
                PUBLISH mergedPublish = PUBLISHFactory.merge(this.inputHolder.get().getPublishPacket(), this.publish);
                this.ctx.writeAndFlush((Object)mergedPublish, this.promise);
            }
        }
    }
}

