/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.iteration;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.services.general.IterationCallback;
import com.hivemq.extension.sdk.api.services.general.IterationContext;
import com.hivemq.extensions.iteration.AsyncIterator;
import com.hivemq.extensions.services.general.IterationContextImpl;
import java.util.Collection;
import java.util.concurrent.Executor;

public class AllItemsItemCallback<T>
implements AsyncIterator.ItemCallback<T> {
    @NotNull
    private final Executor callbackExecutor;
    @NotNull
    private final IterationCallback<T> callback;

    public AllItemsItemCallback(@NotNull Executor callbackExecutor, @NotNull IterationCallback<T> callback) {
        this.callbackExecutor = callbackExecutor;
        this.callback = callback;
    }

    @Override
    @NotNull
    public ListenableFuture<Boolean> onItems(@NotNull Collection<T> items) {
        IterationContextImpl iterationContext = new IterationContextImpl();
        SettableFuture resultFuture = SettableFuture.create();
        this.callbackExecutor.execute(() -> {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.callback.getClass().getClassLoader());
                for (Object item : items) {
                    this.callback.iterate((IterationContext)iterationContext, item);
                    if (!iterationContext.isAborted()) continue;
                    resultFuture.set((Object)false);
                    return;
                }
            }
            catch (Throwable t) {
                resultFuture.setException(t);
                return;
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
            resultFuture.set((Object)true);
        });
        return resultFuture;
    }
}

