/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.loader;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.hivemq.annotations.ReadOnly;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import javax.inject.Singleton;

@Singleton
public class ClassServiceLoader {
    private static final String META_INF_SERVICES = "META-INF/services/";

    @ReadOnly
    @NotNull
    public <S> Iterable<Class<? extends S>> load(@NotNull Class<S> classToLoad, @NotNull ClassLoader classLoader) throws IOException, ClassNotFoundException {
        Preconditions.checkNotNull(classToLoad, (Object)"Class to load mus not be null");
        Preconditions.checkNotNull((Object)classLoader, (Object)"Classloader must not be null");
        ImmutableList.Builder services = ImmutableList.builder();
        Enumeration<URL> urls = classLoader.getResources(META_INF_SERVICES + classToLoad.getName());
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            InputStream is = url.openStream();
            try (InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
                 BufferedReader r = new BufferedReader(isr);){
                String line;
                while ((line = r.readLine()) != null) {
                    String name = (line = this.stripComments(line)).trim();
                    if (name.isEmpty()) continue;
                    Class<?> clazz = Class.forName(name, true, classLoader);
                    services.add(clazz.asSubclass(classToLoad));
                }
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
        return services.build();
    }

    @NotNull
    private String stripComments(@NotNull String line) {
        String tempLine = line;
        int comment = line.indexOf(35);
        if (comment >= 0) {
            tempLine = line.substring(0, comment);
        }
        return tempLine;
    }
}

