/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.packets.connect;

import com.google.common.base.Preconditions;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.annotations.ThreadSafe;
import com.hivemq.extension.sdk.api.packets.connect.WillPublishPacket;
import com.hivemq.extension.sdk.api.packets.general.MqttVersion;
import com.hivemq.extension.sdk.api.packets.publish.ModifiableConnectPacket;
import com.hivemq.extension.sdk.api.packets.publish.ModifiableWillPublish;
import com.hivemq.extension.sdk.api.services.exception.DoNotImplementException;
import com.hivemq.extensions.packets.connect.ConnectPacketImpl;
import com.hivemq.extensions.packets.general.ModifiableUserPropertiesImpl;
import com.hivemq.extensions.packets.publish.ModifiableWillPublishImpl;
import com.hivemq.extensions.packets.publish.WillPublishPacketImpl;
import com.hivemq.util.Utf8Utils;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;

@ThreadSafe
public class ModifiableConnectPacketImpl
implements ModifiableConnectPacket {
    @NotNull
    private final MqttVersion mqttVersion;
    @NotNull
    private String clientId;
    private boolean cleanStart;
    private long sessionExpiryInterval;
    private int keepAlive;
    private int receiveMaximum;
    private long maximumPacketSize;
    private int topicAliasMaximum;
    private boolean requestProblemInformation;
    private boolean requestResponseInformation;
    @Nullable
    private String userName;
    @Nullable
    private ByteBuffer password;
    @Nullable
    private String authenticationMethod;
    @Nullable
    private ByteBuffer authenticationData;
    @Nullable
    private ModifiableWillPublishImpl willPublish;
    @NotNull
    private final ModifiableUserPropertiesImpl userProperties;
    @NotNull
    private final FullConfigurationService configurationService;
    private boolean modified = false;

    public ModifiableConnectPacketImpl(@NotNull ConnectPacketImpl packet, @NotNull FullConfigurationService configurationService) {
        this.mqttVersion = packet.mqttVersion;
        this.clientId = packet.clientId;
        this.cleanStart = packet.cleanStart;
        this.sessionExpiryInterval = packet.sessionExpiryInterval;
        this.keepAlive = packet.keepAlive;
        this.receiveMaximum = packet.receiveMaximum;
        this.maximumPacketSize = packet.maximumPacketSize;
        this.topicAliasMaximum = packet.topicAliasMaximum;
        this.requestProblemInformation = packet.requestProblemInformation;
        this.requestResponseInformation = packet.requestResponseInformation;
        this.userName = packet.userName;
        this.password = packet.password;
        this.authenticationMethod = packet.authenticationMethod;
        this.authenticationData = packet.authenticationData;
        this.willPublish = packet.willPublish == null ? null : new ModifiableWillPublishImpl(packet.willPublish, configurationService);
        this.userProperties = new ModifiableUserPropertiesImpl(packet.userProperties.asInternalList(), configurationService.securityConfiguration().validateUTF8());
        this.configurationService = configurationService;
    }

    @NotNull
    public MqttVersion getMqttVersion() {
        return this.mqttVersion;
    }

    @NotNull
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(@NotNull String clientId) {
        int clientIdLength = this.configurationService.restrictionsConfiguration().maxClientIdLength();
        Preconditions.checkArgument((!Utf8Utils.containsMustNotCharacters(clientId) ? 1 : 0) != 0, (Object)(clientId + " is not a valid client id"));
        Preconditions.checkArgument((!Utf8Utils.hasControlOrNonCharacter(clientId) ? 1 : 0) != 0, (Object)(clientId + " is not a valid client id"));
        Preconditions.checkArgument((clientId.length() < clientIdLength ? 1 : 0) != 0, (Object)"client ID exceeds the maximum client ID length");
        Preconditions.checkArgument((!clientId.isEmpty() ? 1 : 0) != 0, (Object)"client ID must not be empty");
        if (this.clientId.equals(clientId)) {
            return;
        }
        this.clientId = clientId;
        this.modified = true;
    }

    public boolean getCleanStart() {
        return this.cleanStart;
    }

    public void setCleanStart(boolean cleanStart) {
        if (this.cleanStart == cleanStart) {
            return;
        }
        this.cleanStart = cleanStart;
        this.modified = true;
    }

    public long getSessionExpiryInterval() {
        return this.sessionExpiryInterval;
    }

    public void setSessionExpiryInterval(long sessionExpiryInterval) {
        long configuredMaximum = this.configurationService.mqttConfiguration().maxSessionExpiryInterval();
        Preconditions.checkArgument((sessionExpiryInterval >= 0L ? 1 : 0) != 0, (Object)"Session expiry interval must NOT be less than 0");
        Preconditions.checkArgument((sessionExpiryInterval < configuredMaximum ? 1 : 0) != 0, (Object)("Expiry interval must be less than the configured maximum of" + configuredMaximum));
        if (this.sessionExpiryInterval == sessionExpiryInterval) {
            return;
        }
        this.sessionExpiryInterval = sessionExpiryInterval;
        this.modified = true;
    }

    public int getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(int keepAlive) {
        int configuredMaximum = this.configurationService.mqttConfiguration().keepAliveMax();
        Preconditions.checkArgument((keepAlive >= 0 ? 1 : 0) != 0, (Object)"Keep alive must NOT be less than 0");
        Preconditions.checkArgument((keepAlive < configuredMaximum ? 1 : 0) != 0, (Object)("Keep alive must be less than the configured maximum of " + configuredMaximum));
        if (this.keepAlive == keepAlive) {
            return;
        }
        this.keepAlive = keepAlive;
        this.modified = true;
    }

    public int getReceiveMaximum() {
        return this.receiveMaximum;
    }

    public void setReceiveMaximum(int receiveMaximum) {
        Preconditions.checkArgument((receiveMaximum > 0 ? 1 : 0) != 0, (Object)"Receive maximum must be bigger than 0");
        Preconditions.checkArgument((receiveMaximum < 65535 ? 1 : 0) != 0, (Object)"Receive maximum must be less than 65535");
        if (this.receiveMaximum == receiveMaximum) {
            return;
        }
        this.receiveMaximum = receiveMaximum;
        this.modified = true;
    }

    public long getMaximumPacketSize() {
        return this.maximumPacketSize;
    }

    public void setMaximumPacketSize(int maximumPacketSize) {
        int configuredMaximum = this.configurationService.mqttConfiguration().maxPacketSize();
        Preconditions.checkArgument((maximumPacketSize > 0 ? 1 : 0) != 0, (Object)"Maximum packet size must be bigger than 0");
        Preconditions.checkArgument((maximumPacketSize < configuredMaximum ? 1 : 0) != 0, (Object)("Maximum packet must be less than the configured maximum of " + configuredMaximum));
        if (this.maximumPacketSize == (long)maximumPacketSize) {
            return;
        }
        this.maximumPacketSize = maximumPacketSize;
        this.modified = true;
    }

    public int getTopicAliasMaximum() {
        return this.topicAliasMaximum;
    }

    public void setTopicAliasMaximum(int topicAliasMaximum) {
        Preconditions.checkArgument((topicAliasMaximum >= 0 ? 1 : 0) != 0, (Object)"Topic alias must NOT be less than 0");
        Preconditions.checkArgument((topicAliasMaximum < 65535 ? 1 : 0) != 0, (Object)"Maximum packet must be less than 65535");
        if (this.mqttVersion != MqttVersion.V_5) {
            return;
        }
        if (this.topicAliasMaximum == topicAliasMaximum) {
            return;
        }
        this.topicAliasMaximum = topicAliasMaximum;
        this.modified = true;
    }

    public boolean getRequestProblemInformation() {
        return this.requestProblemInformation;
    }

    public void setRequestProblemInformation(boolean requestProblemInformation) {
        if (this.mqttVersion != MqttVersion.V_5) {
            return;
        }
        if (this.requestProblemInformation == requestProblemInformation) {
            return;
        }
        this.requestProblemInformation = requestProblemInformation;
        this.modified = true;
    }

    public boolean getRequestResponseInformation() {
        return this.requestResponseInformation;
    }

    public void setRequestResponseInformation(boolean requestResponseInformation) {
        if (this.mqttVersion != MqttVersion.V_5) {
            return;
        }
        if (this.requestResponseInformation == requestResponseInformation) {
            return;
        }
        this.requestResponseInformation = requestResponseInformation;
        this.modified = true;
    }

    @NotNull
    public Optional<String> getUserName() {
        return Optional.ofNullable(this.userName);
    }

    public void setUserName(@Nullable String userName) {
        if (Objects.equals(this.userName, userName)) {
            return;
        }
        this.userName = userName;
        this.modified = true;
    }

    @NotNull
    public Optional<ByteBuffer> getPassword() {
        return this.password == null ? Optional.empty() : Optional.of(this.password.asReadOnlyBuffer());
    }

    public void setPassword(@Nullable ByteBuffer password) {
        if (Objects.equals(this.password, password)) {
            return;
        }
        this.password = password;
        this.modified = true;
    }

    @NotNull
    public Optional<String> getAuthenticationMethod() {
        return Optional.ofNullable(this.authenticationMethod);
    }

    public void setAuthenticationMethod(@Nullable String authenticationMethod) {
        if (authenticationMethod != null) {
            Preconditions.checkArgument((!Utf8Utils.containsMustNotCharacters(authenticationMethod) ? 1 : 0) != 0, (Object)(authenticationMethod + " is not a valid authentication method"));
            Preconditions.checkArgument((!Utf8Utils.hasControlOrNonCharacter(authenticationMethod) ? 1 : 0) != 0, (Object)(authenticationMethod + " is not a valid authentication method"));
        }
        if (Objects.equals(this.authenticationMethod, authenticationMethod)) {
            return;
        }
        this.authenticationMethod = authenticationMethod;
        this.modified = true;
    }

    @NotNull
    public Optional<ByteBuffer> getAuthenticationData() {
        return this.authenticationData == null ? Optional.empty() : Optional.of(this.authenticationData.asReadOnlyBuffer());
    }

    public void setAuthenticationData(@Nullable ByteBuffer authenticationData) {
        if (Objects.equals(this.authenticationData, authenticationData)) {
            return;
        }
        this.authenticationData = authenticationData;
        this.modified = true;
    }

    @NotNull
    public Optional<WillPublishPacket> getWillPublish() {
        return Optional.ofNullable(this.willPublish);
    }

    @NotNull
    public Optional<ModifiableWillPublish> getModifiableWillPublish() {
        return Optional.ofNullable(this.willPublish);
    }

    public void setWillPublish(@Nullable WillPublishPacket willPublish) {
        ModifiableWillPublishImpl modifiableWillPublish;
        if (willPublish == null) {
            modifiableWillPublish = null;
        } else if (willPublish instanceof WillPublishPacketImpl) {
            modifiableWillPublish = new ModifiableWillPublishImpl((WillPublishPacketImpl)willPublish, this.configurationService);
        } else if (willPublish instanceof ModifiableWillPublishImpl) {
            modifiableWillPublish = (ModifiableWillPublishImpl)willPublish;
        } else {
            throw new DoNotImplementException(WillPublishPacket.class.getSimpleName());
        }
        if (Objects.equals(this.willPublish, modifiableWillPublish)) {
            return;
        }
        this.willPublish = modifiableWillPublish;
        this.modified = true;
    }

    @NotNull
    public ModifiableUserPropertiesImpl getUserProperties() {
        return this.userProperties;
    }

    public boolean isModified() {
        return this.modified || this.userProperties.isModified() || this.willPublish != null && this.willPublish.isModified();
    }

    @NotNull
    public ConnectPacketImpl copy() {
        return new ConnectPacketImpl(this.mqttVersion, this.clientId, this.cleanStart, this.sessionExpiryInterval, this.keepAlive, this.receiveMaximum, this.maximumPacketSize, this.topicAliasMaximum, this.requestProblemInformation, this.requestResponseInformation, this.userName, this.password, this.authenticationMethod, this.authenticationData, this.willPublish == null ? null : this.willPublish.copy(), this.userProperties.copy());
    }

    @NotNull
    public ModifiableConnectPacketImpl update(@NotNull ConnectPacketImpl packet) {
        return new ModifiableConnectPacketImpl(packet, this.configurationService);
    }
}

