/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.packets.puback;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.puback.PubackPacket;
import com.hivemq.extension.sdk.api.packets.publish.AckReasonCode;
import com.hivemq.extensions.packets.general.UserPropertiesImpl;
import com.hivemq.mqtt.message.puback.PUBACK;
import com.hivemq.mqtt.message.reason.Mqtt5PubAckReasonCode;
import java.util.Objects;
import java.util.Optional;

public class PubackPacketImpl
implements PubackPacket {
    final int packetIdentifier;
    @NotNull
    final AckReasonCode reasonCode;
    @Nullable
    final String reasonString;
    @NotNull
    final UserPropertiesImpl userProperties;

    public PubackPacketImpl(int packetIdentifier, @NotNull AckReasonCode reasonCode, @Nullable String reasonString, @NotNull UserPropertiesImpl userProperties) {
        this.packetIdentifier = packetIdentifier;
        this.reasonCode = reasonCode;
        this.reasonString = reasonString;
        this.userProperties = userProperties;
    }

    public PubackPacketImpl(@NotNull PUBACK puback) {
        this(puback.getPacketIdentifier(), ((Mqtt5PubAckReasonCode)puback.getReasonCode()).toAckReasonCode(), puback.getReasonString(), UserPropertiesImpl.of(puback.getUserProperties().asList()));
    }

    public int getPacketIdentifier() {
        return this.packetIdentifier;
    }

    @NotNull
    public AckReasonCode getReasonCode() {
        return this.reasonCode;
    }

    @NotNull
    public Optional<String> getReasonString() {
        return Optional.ofNullable(this.reasonString);
    }

    @NotNull
    public UserPropertiesImpl getUserProperties() {
        return this.userProperties;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PubackPacketImpl)) {
            return false;
        }
        PubackPacketImpl that = (PubackPacketImpl)o;
        return this.packetIdentifier == that.packetIdentifier && this.reasonCode == that.reasonCode && Objects.equals(this.reasonString, that.reasonString) && this.userProperties.equals(that.userProperties);
    }

    public int hashCode() {
        return Objects.hash(this.packetIdentifier, this.reasonCode, this.reasonString, this.userProperties);
    }
}

