/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.packets.unsuback;

import com.google.common.collect.ImmutableList;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.unsuback.UnsubackPacket;
import com.hivemq.extension.sdk.api.packets.unsuback.UnsubackReasonCode;
import com.hivemq.extensions.packets.general.UserPropertiesImpl;
import com.hivemq.mqtt.message.unsuback.UNSUBACK;
import java.util.Objects;
import java.util.Optional;

public class UnsubackPacketImpl
implements UnsubackPacket {
    @NotNull
    final ImmutableList<UnsubackReasonCode> reasonCodes;
    @Nullable
    final String reasonString;
    final int packetIdentifier;
    @NotNull
    final UserPropertiesImpl userProperties;

    public UnsubackPacketImpl(@NotNull ImmutableList<UnsubackReasonCode> reasonCodes, @Nullable String reasonString, int packetIdentifier, @NotNull UserPropertiesImpl userProperties) {
        this.reasonCodes = reasonCodes;
        this.reasonString = reasonString;
        this.packetIdentifier = packetIdentifier;
        this.userProperties = userProperties;
    }

    public UnsubackPacketImpl(@NotNull UNSUBACK unsuback) {
        ImmutableList.Builder builder = ImmutableList.builder();
        unsuback.getReasonCodes().forEach(code -> builder.add((Object)code.toUnsubackReasonCode()));
        this.reasonCodes = builder.build();
        this.reasonString = unsuback.getReasonString();
        this.packetIdentifier = unsuback.getPacketIdentifier();
        this.userProperties = UserPropertiesImpl.of(unsuback.getUserProperties().asList());
    }

    @NotNull
    public ImmutableList<UnsubackReasonCode> getReasonCodes() {
        return this.reasonCodes;
    }

    @NotNull
    public Optional<String> getReasonString() {
        return Optional.ofNullable(this.reasonString);
    }

    public int getPacketIdentifier() {
        return this.packetIdentifier;
    }

    @NotNull
    public UserPropertiesImpl getUserProperties() {
        return this.userProperties;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UnsubackPacketImpl)) {
            return false;
        }
        UnsubackPacketImpl that = (UnsubackPacketImpl)o;
        return this.reasonCodes.equals(that.reasonCodes) && Objects.equals(this.reasonString, that.reasonString) && this.packetIdentifier == that.packetIdentifier && this.userProperties.equals(that.userProperties);
    }

    public int hashCode() {
        return Objects.hash(this.reasonCodes, this.reasonString, this.packetIdentifier, this.userProperties);
    }
}

