/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.services.auth;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extensions.ExtensionPriorityComparator;
import com.hivemq.extensions.HiveMQExtension;
import com.hivemq.extensions.HiveMQExtensions;
import com.hivemq.extensions.services.auth.Authenticators;
import com.hivemq.extensions.services.auth.WrappedAuthenticatorProvider;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@VisibleForTesting
public class AuthenticatorsImpl
implements Authenticators {
    private static final Logger log = LoggerFactory.getLogger(AuthenticatorsImpl.class);
    @NotNull
    private final ReadWriteLock authenticatorsLock = new ReentrantReadWriteLock();
    @NotNull
    private final TreeMap<String, WrappedAuthenticatorProvider> authenticatorPluginMap;
    @NotNull
    private final HiveMQExtensions hiveMQExtensions;

    @Inject
    public AuthenticatorsImpl(@NotNull HiveMQExtensions hiveMQExtensions) {
        this.hiveMQExtensions = hiveMQExtensions;
        this.authenticatorPluginMap = new TreeMap(new ExtensionPriorityComparator(hiveMQExtensions));
    }

    @Override
    @NotNull
    public @NotNull Map<@NotNull String, @NotNull WrappedAuthenticatorProvider> getAuthenticatorProviderMap() {
        Lock readLock = this.authenticatorsLock.readLock();
        readLock.lock();
        try {
            ImmutableMap immutableMap = ImmutableMap.copyOf(this.authenticatorPluginMap);
            return immutableMap;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerAuthenticatorProvider(@NotNull WrappedAuthenticatorProvider provider) {
        Lock writeLock = this.authenticatorsLock.writeLock();
        writeLock.lock();
        try {
            ClassLoader extensionClassLoader = provider.getClassLoader();
            HiveMQExtension extension = this.hiveMQExtensions.getExtensionForClassloader(extensionClassLoader);
            if (extension != null) {
                this.authenticatorPluginMap.put(extension.getId(), provider);
                if (provider.isEnhanced()) {
                    log.debug("Enhanced authenticator added by extension '{}'.", (Object)extension.getId());
                } else {
                    log.debug("Simple authenticator added by extension '{}'.", (Object)extension.getId());
                }
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public void checkAuthenticationSafetyAndLifeness() {
        if (InternalConfigurations.AUTH_DENY_UNAUTHENTICATED_CONNECTIONS.get() && this.getAuthenticatorProviderMap().isEmpty()) {
            log.warn("\n###############################################################################\n# No security extension present, MQTT clients can not connect to this broker. #\n###############################################################################");
        }
    }
}

