/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.services.interceptor;

import com.google.common.collect.ImmutableMap;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.interceptor.connack.ConnackOutboundInterceptorProvider;
import com.hivemq.extension.sdk.api.interceptor.connect.ConnectInboundInterceptorProvider;
import com.hivemq.extensions.ExtensionPriorityComparator;
import com.hivemq.extensions.HiveMQExtension;
import com.hivemq.extensions.HiveMQExtensions;
import com.hivemq.extensions.services.interceptor.Interceptors;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.inject.Inject;

@LazySingleton
public class InterceptorsImpl
implements Interceptors {
    @NotNull
    private final @NotNull Map<@NotNull String, @NotNull ConnectInboundInterceptorProvider> connectInboundInterceptorProviderMap;
    @NotNull
    private final @NotNull Map<@NotNull String, @NotNull ConnackOutboundInterceptorProvider> connackOutboundInterceptorProviderMap;
    @NotNull
    private final HiveMQExtensions hiveMQExtensions;
    @NotNull
    private final ReadWriteLock readWriteLock;

    @Inject
    public InterceptorsImpl(@NotNull HiveMQExtensions hiveMQExtensions) {
        this.hiveMQExtensions = hiveMQExtensions;
        ExtensionPriorityComparator extensionPriorityComparator = new ExtensionPriorityComparator(hiveMQExtensions);
        this.connectInboundInterceptorProviderMap = new TreeMap<String, ConnectInboundInterceptorProvider>(extensionPriorityComparator);
        this.connackOutboundInterceptorProviderMap = new TreeMap<String, ConnackOutboundInterceptorProvider>(extensionPriorityComparator);
        this.readWriteLock = new ReentrantReadWriteLock();
        hiveMQExtensions.addAfterExtensionStopCallback(hiveMQExtension -> {
            ClassLoader pluginClassloader = hiveMQExtension.getExtensionClassloader();
            if (pluginClassloader != null) {
                this.removeInterceptors(hiveMQExtension.getId());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnectInboundInterceptorProvider(@NotNull ConnectInboundInterceptorProvider provider) {
        Lock writeLock = this.readWriteLock.writeLock();
        writeLock.lock();
        try {
            ClassLoader pluginClassloader = provider.getClass().getClassLoader();
            HiveMQExtension plugin = this.hiveMQExtensions.getExtensionForClassloader(pluginClassloader);
            if (plugin != null) {
                this.connectInboundInterceptorProviderMap.put(plugin.getId(), provider);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    @NotNull
    public ImmutableMap<String, ConnectInboundInterceptorProvider> connectInboundInterceptorProviders() {
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try {
            ImmutableMap immutableMap = ImmutableMap.copyOf(this.connectInboundInterceptorProviderMap);
            return immutableMap;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnackOutboundInterceptorProvider(@NotNull ConnackOutboundInterceptorProvider provider) {
        Lock writeLock = this.readWriteLock.writeLock();
        writeLock.lock();
        try {
            ClassLoader pluginClassloader = provider.getClass().getClassLoader();
            HiveMQExtension plugin = this.hiveMQExtensions.getExtensionForClassloader(pluginClassloader);
            if (plugin != null) {
                this.connackOutboundInterceptorProviderMap.put(plugin.getId(), provider);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    @NotNull
    public ImmutableMap<String, ConnackOutboundInterceptorProvider> connackOutboundInterceptorProviders() {
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try {
            ImmutableMap immutableMap = ImmutableMap.copyOf(this.connackOutboundInterceptorProviderMap);
            return immutableMap;
        }
        finally {
            readLock.unlock();
        }
    }

    private void removeInterceptors(@NotNull String pluginId) {
        Lock writeLock = this.readWriteLock.writeLock();
        writeLock.lock();
        try {
            this.connectInboundInterceptorProviderMap.remove(pluginId);
            this.connackOutboundInterceptorProviderMap.remove(pluginId);
        }
        finally {
            writeLock.unlock();
        }
    }
}

