/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.ioc;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Injector;
import com.hivemq.bootstrap.ioc.SingletonModule;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.mqtt.handler.connack.MqttConnacker;
import com.hivemq.mqtt.handler.connack.MqttConnackerImpl;
import com.hivemq.mqtt.handler.disconnect.MqttServerDisconnector;
import com.hivemq.mqtt.handler.disconnect.MqttServerDisconnectorImpl;
import com.hivemq.mqtt.message.dropping.MessageDroppedService;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import javax.inject.Singleton;

public class MQTTHandlerModule
extends SingletonModule<Class<MQTTHandlerModule>> {
    @NotNull
    private final Injector persistenceInjector;

    public MQTTHandlerModule(@NotNull Injector persistenceInjector) {
        super(MQTTHandlerModule.class);
        this.persistenceInjector = persistenceInjector;
    }

    protected void configure() {
        DefaultEventExecutorGroup mqttHandlerWorker = new DefaultEventExecutorGroup(InternalConfigurations.MQTT_EVENT_EXECUTOR_THREAD_COUNT.get(), new ThreadFactoryBuilder().setNameFormat("hivemq-event-executor-%d").build());
        this.bind(EventExecutorGroup.class).toInstance((Object)mqttHandlerWorker);
        this.bind(MessageDroppedService.class).toInstance((Object)((MessageDroppedService)this.persistenceInjector.getInstance(MessageDroppedService.class)));
        this.bind(MqttServerDisconnector.class).to(MqttServerDisconnectorImpl.class).in(Singleton.class);
        this.bind(MqttConnacker.class).to(MqttConnackerImpl.class).in(Singleton.class);
    }
}

