/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.message;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.general.Qos;

public enum QoS {
    AT_MOST_ONCE(0),
    AT_LEAST_ONCE(1),
    EXACTLY_ONCE(2);

    @NotNull
    private static final @NotNull QoS @NotNull [] VALUES;
    private final int qosNumber;
    @NotNull
    private final Qos qos;
    @NotNull
    private static final @NotNull QoS @NotNull [] LOOKUP;

    private QoS(int qosNumber) {
        this.qosNumber = qosNumber;
        this.qos = Qos.valueOf((String)this.name());
    }

    public int getQosNumber() {
        return this.qosNumber;
    }

    @NotNull
    public Qos toQos() {
        return this.qos;
    }

    @Nullable
    public static QoS valueOf(int i) {
        return i >= 0 && i < VALUES.length ? VALUES[i] : null;
    }

    @NotNull
    public static QoS from(@NotNull Qos qos) {
        return LOOKUP[qos.ordinal()];
    }

    @NotNull
    public static QoS getMinQoS(@NotNull QoS qosFirst, @NotNull QoS qosSecond) {
        if (qosFirst.getQosNumber() < qosSecond.getQosNumber()) {
            return qosFirst;
        }
        return qosSecond;
    }

    static {
        VALUES = QoS.values();
        LOOKUP = new QoS[Qos.values().length];
        QoS[] qoSArray = QoS.values();
        int n = qoSArray.length;
        for (int i = 0; i < n; ++i) {
            QoS qoS;
            QoS.LOOKUP[qoS.qos.ordinal()] = qoS = qoSArray[i];
        }
    }
}

