/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.message.auth;

import com.google.common.base.Preconditions;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.message.MessageType;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.mqtt5.MqttMessageWithUserProperties;
import com.hivemq.mqtt.message.reason.Mqtt5AuthReasonCode;

public class AUTH
extends MqttMessageWithUserProperties.MqttMessageWithReasonCode<Mqtt5AuthReasonCode> {
    @NotNull
    private final String authMethod;
    @Nullable
    private final byte[] authData;

    public AUTH(@NotNull String authMethod, @Nullable byte[] authData, @NotNull Mqtt5AuthReasonCode reasonCode, @NotNull Mqtt5UserProperties userProperties, @Nullable String reasonString) {
        super(reasonCode, reasonString, userProperties);
        Preconditions.checkNotNull((Object)reasonCode, (Object)"Reason code must never be null");
        Preconditions.checkNotNull((Object)authMethod, (Object)"Auth method must never be null");
        this.authMethod = authMethod;
        this.authData = authData;
    }

    @Nullable
    public byte[] getAuthData() {
        return this.authData;
    }

    @NotNull
    public String getAuthMethod() {
        return this.authMethod;
    }

    public static AUTH getSuccessAUTH() {
        return new AUTH("", null, Mqtt5AuthReasonCode.SUCCESS, Mqtt5UserProperties.NO_USER_PROPERTIES, null);
    }

    @Override
    @NotNull
    public MessageType getType() {
        return MessageType.AUTH;
    }
}

