/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.message.connack;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.general.Qos;
import com.hivemq.extensions.packets.connack.ConnackPacketImpl;
import com.hivemq.mqtt.message.MessageType;
import com.hivemq.mqtt.message.QoS;
import com.hivemq.mqtt.message.connack.CONNACKBuilder;
import com.hivemq.mqtt.message.connack.Mqtt3CONNACK;
import com.hivemq.mqtt.message.connack.Mqtt3ConnAckReturnCode;
import com.hivemq.mqtt.message.connack.Mqtt5CONNACK;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.mqtt5.MqttMessageWithUserProperties;
import com.hivemq.mqtt.message.reason.Mqtt5ConnAckReasonCode;
import com.hivemq.util.Bytes;

public class CONNACK
extends MqttMessageWithUserProperties.MqttMessageWithReasonCode<Mqtt5ConnAckReasonCode>
implements Mqtt3CONNACK,
Mqtt5CONNACK {
    public static final long SESSION_EXPIRY_NOT_SET = Long.MAX_VALUE;
    public static final int KEEP_ALIVE_NOT_SET = -1;
    private final boolean sessionPresent;
    private final long sessionExpiryInterval;
    private final int serverKeepAlive;
    @Nullable
    private final String assignedClientIdentifier;
    @Nullable
    private final String authMethod;
    private final byte @Nullable [] authData;
    private final int receiveMaximum;
    private final int topicAliasMaximum;
    private final int maximumPacketSize;
    @Nullable
    private final QoS maximumQoS;
    private final boolean isRetainAvailable;
    private final boolean isWildcardSubscriptionAvailable;
    private final boolean isSubscriptionIdentifierAvailable;
    private final boolean isSharedSubscriptionAvailable;
    @Nullable
    private final String responseInformation;
    @Nullable
    private final String serverReference;

    @NotNull
    public static CONNACKBuilder builder() {
        return new CONNACKBuilder();
    }

    @NotNull
    public static CONNACK from(@NotNull ConnackPacketImpl packet) {
        Qos extensionMaxQos = packet.getMaximumQoS().orElse(null);
        QoS qoS = extensionMaxQos != null ? QoS.valueOf(extensionMaxQos.getQosNumber()) : null;
        return new CONNACKBuilder().withReasonCode(Mqtt5ConnAckReasonCode.from(packet.getReasonCode())).withSessionPresent(packet.getSessionPresent()).withSessionExpiryInterval(packet.getSessionExpiryInterval().orElse(Long.MAX_VALUE)).withServerKeepAlive(packet.getServerKeepAlive().orElse(-1)).withAssignedClientIdentifier(packet.getAssignedClientIdentifier().orElse(null)).withAuthMethod(packet.getAuthenticationMethod().orElse(null)).withAuthData(Bytes.getBytesFromReadOnlyBuffer(packet.getAuthenticationData())).withReceiveMaximum(packet.getReceiveMaximum()).withMaximumPacketSize(packet.getMaximumPacketSize()).withTopicAliasMaximum(packet.getTopicAliasMaximum()).withMaximumQoS(qoS).withRetainAvailable(packet.getRetainAvailable()).withWildcardSubscriptionAvailable(packet.getWildCardSubscriptionAvailable()).withSharedSubscriptionAvailable(packet.getSharedSubscriptionsAvailable()).withSubscriptionIdentifierAvailable(packet.getSubscriptionIdentifiersAvailable()).withResponseInformation(packet.getResponseInformation().orElse(null)).withServerReference(packet.getServerReference().orElse(null)).withReasonString(packet.getReasonString().orElse(null)).withUserProperties(Mqtt5UserProperties.of(packet.getUserProperties().asInternalList())).build();
    }

    CONNACK(@NotNull Mqtt5ConnAckReasonCode reasonCode, @Nullable String reasonString, @NotNull Mqtt5UserProperties userProperties, boolean sessionPresent, long sessionExpiryInterval, int serverKeepAlive, @Nullable String assignedClientIdentifier, @Nullable String authMethod, byte @Nullable [] authData, int receiveMaximum, int topicAliasMaximum, int maximumPacketSize, @Nullable QoS maximumQoS, boolean isRetainAvailable, boolean isWildcardSubscriptionAvailable, boolean isSubscriptionIdentifierAvailable, boolean isSharedSubscriptionAvailable, @Nullable String responseInformation, @Nullable String serverReference) {
        super(reasonCode, reasonString, userProperties);
        this.sessionPresent = sessionPresent;
        this.sessionExpiryInterval = sessionExpiryInterval;
        this.serverKeepAlive = serverKeepAlive;
        this.assignedClientIdentifier = assignedClientIdentifier;
        this.authMethod = authMethod;
        this.authData = authData;
        this.receiveMaximum = receiveMaximum;
        this.topicAliasMaximum = topicAliasMaximum;
        this.maximumPacketSize = maximumPacketSize;
        this.maximumQoS = maximumQoS;
        this.isRetainAvailable = isRetainAvailable;
        this.isWildcardSubscriptionAvailable = isWildcardSubscriptionAvailable;
        this.isSubscriptionIdentifierAvailable = isSubscriptionIdentifierAvailable;
        this.isSharedSubscriptionAvailable = isSharedSubscriptionAvailable;
        this.responseInformation = responseInformation;
        this.serverReference = serverReference;
    }

    @Override
    public int getReceiveMaximum() {
        return this.receiveMaximum;
    }

    @Override
    public int getTopicAliasMaximum() {
        return this.topicAliasMaximum;
    }

    @Override
    public int getMaximumPacketSize() {
        return this.maximumPacketSize;
    }

    @Override
    @NotNull
    public Mqtt3ConnAckReturnCode getReturnCode() {
        return Mqtt3ConnAckReturnCode.fromReasonCode((Mqtt5ConnAckReasonCode)this.getReasonCode());
    }

    @Override
    public boolean isRetainAvailable() {
        return this.isRetainAvailable;
    }

    @Override
    public boolean isWildcardSubscriptionAvailable() {
        return this.isWildcardSubscriptionAvailable;
    }

    @Override
    public boolean isSubscriptionIdentifierAvailable() {
        return this.isSubscriptionIdentifierAvailable;
    }

    @Override
    public boolean isSharedSubscriptionAvailable() {
        return this.isSharedSubscriptionAvailable;
    }

    @Override
    public boolean isSessionPresent() {
        return this.sessionPresent;
    }

    @Override
    public long getSessionExpiryInterval() {
        return this.sessionExpiryInterval;
    }

    @Override
    public int getServerKeepAlive() {
        return this.serverKeepAlive;
    }

    @Override
    @Nullable
    public QoS getMaximumQoS() {
        return this.maximumQoS;
    }

    @Override
    @Nullable
    public String getAssignedClientIdentifier() {
        return this.assignedClientIdentifier;
    }

    @Override
    @Nullable
    public String getAuthMethod() {
        return this.authMethod;
    }

    @Override
    public byte @Nullable [] getAuthData() {
        return this.authData;
    }

    @Override
    @Nullable
    public String getResponseInformation() {
        return this.responseInformation;
    }

    @Override
    @NotNull
    public MessageType getType() {
        return MessageType.CONNACK;
    }

    @Override
    @Nullable
    public String getServerReference() {
        return this.serverReference;
    }
}

