/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.message.connack;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.mqtt.message.reason.Mqtt5ConnAckReasonCode;

public enum Mqtt3ConnAckReturnCode {
    ACCEPTED(0),
    REFUSED_UNACCEPTABLE_PROTOCOL_VERSION(1),
    REFUSED_IDENTIFIER_REJECTED(2),
    REFUSED_SERVER_UNAVAILABLE(3),
    REFUSED_BAD_USERNAME_OR_PASSWORD(4),
    REFUSED_NOT_AUTHORIZED(5);

    @NotNull
    private static final @NotNull Mqtt3ConnAckReturnCode @NotNull [] VALUES;
    private final int code;

    private Mqtt3ConnAckReturnCode(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    @NotNull
    public static Mqtt3ConnAckReturnCode fromCode(int code) {
        try {
            return VALUES[code];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("No Return code with value " + code + " defined", e);
        }
    }

    @NotNull
    public static Mqtt3ConnAckReturnCode fromReasonCode(@NotNull Mqtt5ConnAckReasonCode reasonCode) {
        switch (reasonCode) {
            case SUCCESS: {
                return ACCEPTED;
            }
            case UNSUPPORTED_PROTOCOL_VERSION: {
                return REFUSED_UNACCEPTABLE_PROTOCOL_VERSION;
            }
            case CLIENT_IDENTIFIER_NOT_VALID: {
                return REFUSED_IDENTIFIER_REJECTED;
            }
            case SERVER_UNAVAILABLE: 
            case SERVER_BUSY: 
            case USE_ANOTHER_SERVER: 
            case SERVER_MOVED: {
                return REFUSED_SERVER_UNAVAILABLE;
            }
            case BAD_USER_NAME_OR_PASSWORD: 
            case BAD_AUTHENTICATION_METHOD: {
                return REFUSED_BAD_USERNAME_OR_PASSWORD;
            }
        }
        return REFUSED_NOT_AUTHORIZED;
    }

    static {
        VALUES = Mqtt3ConnAckReturnCode.values();
    }
}

