/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.message.mqtt5;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.mqtt5.MqttUserProperty;
import com.hivemq.persistence.local.xodus.XodusUtils;
import com.hivemq.util.Bytes;

public class PropertiesSerializationUtil {
    public static int encodedSize(Mqtt5UserProperties properties) {
        int size = 4;
        for (MqttUserProperty property : properties.asList()) {
            size += XodusUtils.shortLengthStringSize(property.getName());
            size += XodusUtils.shortLengthStringSize(property.getValue());
        }
        return size;
    }

    public static int write(@NotNull Mqtt5UserProperties properties, @NotNull byte[] bytes, int offset) {
        Bytes.copyIntToByteArray(properties.asList().size(), bytes, offset);
        offset += 4;
        for (MqttUserProperty property : properties.asList()) {
            offset = XodusUtils.serializeShortLengthString(property.getName(), bytes, offset);
            offset = XodusUtils.serializeShortLengthString(property.getValue(), bytes, offset);
        }
        return offset;
    }

    @NotNull
    public static Mqtt5UserProperties read(@NotNull byte[] bytes, int offset) {
        int size = Bytes.readInt(bytes, offset);
        offset += 4;
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)size);
        for (int i = 0; i < size; ++i) {
            int nameLength = Bytes.readUnsignedShort(bytes, offset);
            String name = new String(bytes, offset += 2, nameLength, Charsets.UTF_8);
            int valueLength = Bytes.readUnsignedShort(bytes, offset += nameLength);
            String value = new String(bytes, offset += 2, valueLength, Charsets.UTF_8);
            offset += valueLength;
            builder.add((Object)new MqttUserProperty(name, value));
        }
        return Mqtt5UserProperties.of((ImmutableList<MqttUserProperty>)builder.build());
    }
}

