/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.message.publish;

import com.google.common.base.Preconditions;
import com.google.common.primitives.ImmutableIntArray;
import com.hivemq.codec.encoder.mqtt5.Mqtt5PayloadFormatIndicator;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extensions.packets.publish.PublishPacketImpl;
import com.hivemq.mqtt.message.QoS;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.publish.PUBLISH;
import com.hivemq.util.Bytes;

public class PUBLISHFactory {
    @NotNull
    public static PUBLISH merge(@NotNull PublishPacketImpl packet, @NotNull PUBLISH origin) {
        Mqtt5PayloadFormatIndicator payloadFormatIndicator = packet.getPayloadFormatIndicator().isPresent() ? Mqtt5PayloadFormatIndicator.from(packet.getPayloadFormatIndicator().get()) : null;
        return new Mqtt5Builder().withTimestamp(origin.getTimestamp()).withPublishId(origin.getPublishId()).withHivemqId(origin.getHivemqId()).withTopic(packet.getTopic()).withQoS(QoS.from(packet.getQos())).withOnwardQos(QoS.from(packet.getOnwardQos())).withPayload(Bytes.getBytesFromReadOnlyBuffer(packet.getPayload())).withRetain(packet.getRetain()).withMessageExpiryInterval(packet.getMessageExpiryInterval().orElse(Long.MAX_VALUE)).withDuplicateDelivery(packet.getDupFlag()).withPacketIdentifier(packet.getPacketId()).withPayloadFormatIndicator(payloadFormatIndicator).withContentType(packet.getContentType().orElse(null)).withResponseTopic(packet.getResponseTopic().orElse(null)).withCorrelationData(Bytes.getBytesFromReadOnlyBuffer(packet.getCorrelationData())).withNewTopicAlias(origin.isNewTopicAlias()).withSubscriptionIdentifiers(ImmutableIntArray.copyOf(packet.getSubscriptionIdentifiers())).withUserProperties(Mqtt5UserProperties.of(packet.getUserProperties().asInternalList())).build();
    }

    public static class Mqtt3Builder {
        @Nullable
        private String hivemqId;
        @Nullable
        private String topic;
        @NotNull
        private QoS qoS;
        @NotNull
        private QoS onwardQos;
        @Nullable
        private byte[] payload;
        private boolean retain;
        private long messageExpiryInterval = Long.MAX_VALUE;
        private boolean duplicateDelivery;
        private int packetIdentifier;
        private long publishId = -1L;
        private long timestamp = -1L;

        @NotNull
        public Mqtt3Builder fromPublish(@NotNull PUBLISH publish) {
            this.hivemqId = publish.getHivemqId();
            this.topic = publish.getTopic();
            this.qoS = publish.getQoS();
            this.onwardQos = publish.getOnwardQoS();
            this.payload = publish.getPayload();
            this.retain = publish.isRetain();
            this.messageExpiryInterval = publish.getMessageExpiryInterval();
            this.duplicateDelivery = publish.isDuplicateDelivery();
            this.packetIdentifier = publish.getPacketIdentifier();
            this.publishId = publish.getPublishId();
            return this;
        }

        @NotNull
        public PUBLISH build() {
            Preconditions.checkNotNull((Object)this.hivemqId, (Object)"HivemqId may never be null");
            Preconditions.checkNotNull((Object)this.topic, (Object)"Topic may never be null");
            Preconditions.checkNotNull((Object)((Object)this.qoS), (Object)"Quality of service may never be null");
            return new PUBLISH(this.hivemqId, this.topic, this.payload, this.qoS, this.onwardQos, this.retain, this.messageExpiryInterval, this.packetIdentifier, this.duplicateDelivery, this.publishId, this.timestamp);
        }

        @NotNull
        public Mqtt3Builder withTimestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @NotNull
        public Mqtt3Builder withHivemqId(@Nullable String hivemqId) {
            this.hivemqId = hivemqId;
            return this;
        }

        @NotNull
        public Mqtt3Builder withTopic(@Nullable String topic) {
            this.topic = topic;
            return this;
        }

        @NotNull
        public Mqtt3Builder withQoS(@NotNull QoS qoS) {
            this.qoS = qoS;
            return this;
        }

        @NotNull
        public Mqtt3Builder withOnwardQos(@NotNull QoS onwardQos) {
            this.onwardQos = onwardQos;
            return this;
        }

        @NotNull
        public Mqtt3Builder withPayload(@Nullable byte[] payload) {
            this.payload = payload;
            return this;
        }

        @NotNull
        public Mqtt3Builder withRetain(boolean retain) {
            this.retain = retain;
            return this;
        }

        @NotNull
        public Mqtt3Builder withMessageExpiryInterval(long messageExpiryInterval) {
            this.messageExpiryInterval = messageExpiryInterval;
            return this;
        }

        @NotNull
        public Mqtt3Builder withDuplicateDelivery(boolean duplicateDelivery) {
            this.duplicateDelivery = duplicateDelivery;
            return this;
        }

        @NotNull
        public Mqtt3Builder withPacketIdentifier(int packetIdentifier) {
            this.packetIdentifier = packetIdentifier;
            return this;
        }

        @NotNull
        public Mqtt3Builder withPublishId(long publishId) {
            this.publishId = publishId;
            return this;
        }
    }

    public static class Mqtt5Builder {
        private long timestamp = System.currentTimeMillis();
        @Nullable
        private byte[] payload;
        @Nullable
        private String topic;
        private boolean duplicateDelivery;
        private boolean retain;
        @NotNull
        private QoS qoS;
        @NotNull
        private QoS onwardQos;
        private long messageExpiryInterval = Long.MAX_VALUE;
        @Nullable
        private String hivemqId;
        @Nullable
        private Mqtt5PayloadFormatIndicator payloadFormatIndicator;
        @Nullable
        private String contentType;
        @Nullable
        private String responseTopic;
        @Nullable
        private byte[] correlationData;
        private boolean isNewTopicAlias;
        @Nullable
        private ImmutableIntArray subscriptionIdentifiers;
        @NotNull
        private Mqtt5UserProperties userProperties = Mqtt5UserProperties.NO_USER_PROPERTIES;
        private int packetIdentifier;
        private long publishId = -1L;

        @NotNull
        public Mqtt5Builder fromPublish(@NotNull PUBLISH publish) {
            this.hivemqId = publish.getHivemqId();
            this.topic = publish.getTopic();
            this.qoS = publish.getQoS();
            this.onwardQos = publish.getOnwardQoS();
            this.payload = publish.getPayload();
            this.retain = publish.isRetain();
            this.messageExpiryInterval = publish.getMessageExpiryInterval();
            this.duplicateDelivery = publish.isDuplicateDelivery();
            this.packetIdentifier = publish.getPacketIdentifier();
            this.publishId = publish.getPublishId();
            this.userProperties = publish.getUserProperties();
            this.responseTopic = publish.getResponseTopic();
            this.correlationData = publish.getCorrelationData();
            this.contentType = publish.getContentType();
            this.payloadFormatIndicator = publish.getPayloadFormatIndicator();
            this.timestamp = publish.getTimestamp();
            this.subscriptionIdentifiers = publish.getSubscriptionIdentifiers();
            return this;
        }

        @NotNull
        public PUBLISH build() {
            Preconditions.checkNotNull((Object)this.hivemqId, (Object)"HivemqId may never be null");
            Preconditions.checkNotNull((Object)this.topic, (Object)"Topic may never be null");
            Preconditions.checkNotNull((Object)((Object)this.qoS), (Object)"Quality of service may never be null");
            return new PUBLISH(this.hivemqId, this.topic, this.payload, this.qoS, this.onwardQos, this.retain, this.messageExpiryInterval, this.payloadFormatIndicator, this.contentType, this.responseTopic, this.correlationData, this.userProperties, this.packetIdentifier, this.duplicateDelivery, this.isNewTopicAlias, this.subscriptionIdentifiers, this.timestamp, this.publishId);
        }

        @NotNull
        public Mqtt5Builder withTimestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @NotNull
        public Mqtt5Builder withPayload(@Nullable byte[] payload) {
            this.payload = payload;
            return this;
        }

        @NotNull
        public Mqtt5Builder withTopic(@Nullable String topic) {
            this.topic = topic;
            return this;
        }

        @NotNull
        public Mqtt5Builder withDuplicateDelivery(boolean duplicateDelivery) {
            this.duplicateDelivery = duplicateDelivery;
            return this;
        }

        @NotNull
        public Mqtt5Builder withRetain(boolean retain) {
            this.retain = retain;
            return this;
        }

        @NotNull
        public Mqtt5Builder withQoS(@NotNull QoS qoS) {
            this.qoS = qoS;
            return this;
        }

        @NotNull
        public Mqtt5Builder withOnwardQos(@NotNull QoS onwardQos) {
            this.onwardQos = onwardQos;
            return this;
        }

        @NotNull
        public Mqtt5Builder withMessageExpiryInterval(long messageExpiryInterval) {
            this.messageExpiryInterval = messageExpiryInterval;
            return this;
        }

        @NotNull
        public Mqtt5Builder withHivemqId(@Nullable String hivemqId) {
            this.hivemqId = hivemqId;
            return this;
        }

        @NotNull
        public Mqtt5Builder withPayloadFormatIndicator(@Nullable Mqtt5PayloadFormatIndicator payloadFormatIndicator) {
            this.payloadFormatIndicator = payloadFormatIndicator;
            return this;
        }

        @NotNull
        public Mqtt5Builder withContentType(@Nullable String contentType) {
            this.contentType = contentType;
            return this;
        }

        @NotNull
        public Mqtt5Builder withResponseTopic(@Nullable String responseTopic) {
            this.responseTopic = responseTopic;
            return this;
        }

        @NotNull
        public Mqtt5Builder withCorrelationData(@Nullable byte[] correlationData) {
            this.correlationData = correlationData;
            return this;
        }

        @NotNull
        public Mqtt5Builder withNewTopicAlias(boolean newTopicAlias) {
            this.isNewTopicAlias = newTopicAlias;
            return this;
        }

        @NotNull
        public Mqtt5Builder withSubscriptionIdentifiers(@Nullable ImmutableIntArray subscriptionIdentifiers) {
            this.subscriptionIdentifiers = subscriptionIdentifiers;
            return this;
        }

        @NotNull
        public Mqtt5Builder withUserProperties(@NotNull Mqtt5UserProperties userProperties) {
            this.userProperties = userProperties;
            return this;
        }

        @NotNull
        public Mqtt5Builder withPacketIdentifier(int packetIdentifier) {
            this.packetIdentifier = packetIdentifier;
            return this;
        }

        @NotNull
        public Mqtt5Builder withPublishId(long publishId) {
            this.publishId = publishId;
            return this;
        }
    }
}

