/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.message.suback;

import com.google.common.collect.ImmutableList;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extensions.packets.suback.SubackPacketImpl;
import com.hivemq.mqtt.message.MessageType;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.mqtt5.MqttMessageWithUserProperties;
import com.hivemq.mqtt.message.reason.Mqtt5SubAckReasonCode;
import com.hivemq.mqtt.message.suback.Mqtt3SUBACK;
import com.hivemq.mqtt.message.suback.Mqtt5SUBACK;
import java.util.List;

public class SUBACK
extends MqttMessageWithUserProperties.MqttMessageWithIdAndReasonCodes<Mqtt5SubAckReasonCode>
implements Mqtt3SUBACK,
Mqtt5SUBACK {
    public SUBACK(int packetIdentifier, Mqtt5SubAckReasonCode ... entries) {
        super(packetIdentifier, ImmutableList.copyOf((Object[])entries), null, Mqtt5UserProperties.NO_USER_PROPERTIES);
    }

    public SUBACK(int packetIdentifier, @NotNull List<Mqtt5SubAckReasonCode> grantedQos) {
        this(packetIdentifier, grantedQos, null, Mqtt5UserProperties.NO_USER_PROPERTIES);
    }

    public SUBACK(int packetIdentifier, @NotNull List<Mqtt5SubAckReasonCode> grantedQos, @Nullable String reasonString) {
        this(packetIdentifier, grantedQos, reasonString, Mqtt5UserProperties.NO_USER_PROPERTIES);
    }

    public SUBACK(int packetIdentifier, @NotNull List<Mqtt5SubAckReasonCode> grantedQos, @Nullable String reasonString, @NotNull Mqtt5UserProperties userProperties) {
        super(packetIdentifier, ImmutableList.copyOf(grantedQos), reasonString, userProperties);
    }

    public SUBACK(int packetIdentifier, @Nullable String reasonString, @NotNull Mqtt5UserProperties userProperties, Mqtt5SubAckReasonCode ... grantedQos) {
        super(packetIdentifier, ImmutableList.copyOf((Object[])grantedQos), reasonString, userProperties);
    }

    @Override
    @NotNull
    public MessageType getType() {
        return MessageType.SUBACK;
    }

    @NotNull
    public static SUBACK from(@NotNull SubackPacketImpl packet) {
        ImmutableList.Builder reasonCodesBuilder = ImmutableList.builder();
        packet.getReasonCodes().forEach(reasonCode -> reasonCodesBuilder.add((Object)Mqtt5SubAckReasonCode.from(reasonCode)));
        return new SUBACK(packet.getPacketIdentifier(), (List<Mqtt5SubAckReasonCode>)reasonCodesBuilder.build(), (String)packet.getReasonString().orElse(null), Mqtt5UserProperties.of(packet.getUserProperties().asInternalList()));
    }
}

