/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.services;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.handler.publish.PublishReturnCode;
import com.hivemq.mqtt.message.publish.PUBLISH;
import com.hivemq.mqtt.services.InternalPublishService;
import com.hivemq.mqtt.services.PublishDistributor;
import com.hivemq.mqtt.topic.SubscriberWithIdentifiers;
import com.hivemq.mqtt.topic.tree.LocalTopicTree;
import com.hivemq.mqtt.topic.tree.TopicSubscribers;
import com.hivemq.persistence.RetainedMessage;
import com.hivemq.persistence.retained.RetainedMessagePersistence;
import com.hivemq.util.Exceptions;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LazySingleton
public class InternalPublishServiceImpl
implements InternalPublishService {
    private static final Logger log = LoggerFactory.getLogger(InternalPublishServiceImpl.class);
    private final RetainedMessagePersistence retainedMessagePersistence;
    private final LocalTopicTree topicTree;
    private final PublishDistributor publishDistributor;
    private final boolean acknowledgeAfterPersist;

    @Inject
    public InternalPublishServiceImpl(RetainedMessagePersistence retainedMessagePersistence, LocalTopicTree topicTree, PublishDistributor publishDistributor) {
        this.retainedMessagePersistence = retainedMessagePersistence;
        this.topicTree = topicTree;
        this.publishDistributor = publishDistributor;
        this.acknowledgeAfterPersist = InternalConfigurations.ACKNOWLEDGE_INCOMING_PUBLISH_AFTER_PERSISTING_ENABLED.get();
    }

    @Override
    @NotNull
    public ListenableFuture<PublishReturnCode> publish(@NotNull PUBLISH publish, @NotNull ExecutorService executorService, @Nullable String sender) {
        Preconditions.checkNotNull((Object)publish, (Object)"PUBLISH can not be null");
        Preconditions.checkNotNull((Object)executorService, (Object)"executorService can not be null");
        publish.setDuplicateDelivery(false);
        ListenableFuture<Void> persistFuture = this.persistRetainedMessage(publish, executorService);
        ListenableFuture<PublishReturnCode> publishReturnCodeFuture = this.handlePublish(publish, executorService, sender);
        return Futures.whenAllComplete((ListenableFuture[])new ListenableFuture[]{publishReturnCodeFuture, persistFuture}).call(() -> (PublishReturnCode)((Object)((Object)publishReturnCodeFuture.get())), (Executor)executorService);
    }

    private ListenableFuture<Void> persistRetainedMessage(final PUBLISH publish, ExecutorService executorService) {
        if (publish.isRetain()) {
            ListenableFuture<Void> persistFuture;
            final SettableFuture persistSettableFuture = SettableFuture.create();
            if (publish.getPayload().length > 0) {
                RetainedMessage retainedMessage = new RetainedMessage(publish, publish.getMessageExpiryInterval());
                log.trace("Adding retained message on topic {}", (Object)publish.getTopic());
                persistFuture = this.retainedMessagePersistence.persist(publish.getTopic(), retainedMessage);
            } else {
                log.trace("Deleting retained message on topic {}", (Object)publish.getTopic());
                persistFuture = this.retainedMessagePersistence.remove(publish.getTopic());
            }
            if (!this.acknowledgeAfterPersist) {
                persistSettableFuture.set(null);
            } else {
                Futures.addCallback(persistFuture, (FutureCallback)new FutureCallback<Void>(){

                    public void onSuccess(@Nullable Void aVoid) {
                        persistSettableFuture.set(null);
                    }

                    public void onFailure(@NotNull Throwable throwable) {
                        Exceptions.rethrowError("Unable able to store retained message for topic " + publish.getTopic() + " with message id " + publish.getUniqueId() + ".", throwable);
                        persistSettableFuture.set(null);
                    }
                }, (Executor)executorService);
            }
            return persistSettableFuture;
        }
        return Futures.immediateFuture(null);
    }

    @NotNull
    private ListenableFuture<PublishReturnCode> handlePublish(@NotNull PUBLISH publish, @NotNull ExecutorService executorService, @Nullable String sender) {
        TopicSubscribers topicSubscribers = this.topicTree.findTopicSubscribers(publish.getTopic());
        ImmutableSet<SubscriberWithIdentifiers> subscribers = topicSubscribers.getSubscribers();
        ImmutableSet<String> sharedSubscriptions = topicSubscribers.getSharedSubscriptions();
        if (subscribers.isEmpty() && sharedSubscriptions.isEmpty()) {
            if (log.isTraceEnabled()) {
                log.trace("No matching normal/shared subscriber found for PUBLISH with topic '{}'", (Object)publish.getTopic());
            }
            return Futures.immediateFuture((Object)((Object)PublishReturnCode.NO_MATCHING_SUBSCRIBERS));
        }
        if (!this.acknowledgeAfterPersist) {
            this.deliverPublish(topicSubscribers, sender, publish, executorService, null);
            return Futures.immediateFuture((Object)((Object)PublishReturnCode.DELIVERED));
        }
        SettableFuture returnCodeFuture = SettableFuture.create();
        this.deliverPublish(topicSubscribers, sender, publish, executorService, (SettableFuture<PublishReturnCode>)returnCodeFuture);
        return returnCodeFuture;
    }

    private void deliverPublish(@NotNull TopicSubscribers topicSubscribers, @Nullable String sender, final @NotNull PUBLISH publish, @NotNull ExecutorService executorService, final @Nullable SettableFuture<PublishReturnCode> returnCodeFuture) {
        ImmutableSet<String> sharedSubscriptions = topicSubscribers.getSharedSubscriptions();
        HashMap<String, SubscriberWithIdentifiers> notSharedSubscribers = new HashMap<String, SubscriberWithIdentifiers>(topicSubscribers.getSubscribers().size());
        for (SubscriberWithIdentifiers subscriber : topicSubscribers.getSubscribers()) {
            if (subscriber.isSharedSubscription() || subscriber.isNoLocal() && sender != null && sender.equals(subscriber.getSubscriber())) continue;
            notSharedSubscribers.put(subscriber.getSubscriber(), subscriber);
        }
        ListenableFuture<Void> publishFinishedFutureNonShared = this.publishDistributor.distributeToNonSharedSubscribers(notSharedSubscribers, publish, executorService);
        ListenableFuture<Void> publishFinishedFutureShared = sharedSubscriptions != null ? this.publishDistributor.distributeToSharedSubscribers((Set<String>)sharedSubscriptions, publish, executorService) : Futures.immediateFuture(null);
        Futures.addCallback((ListenableFuture)Futures.allAsList((ListenableFuture[])new ListenableFuture[]{publishFinishedFutureNonShared, publishFinishedFutureShared}), (FutureCallback)new FutureCallback<List<Void>>(){

            public void onSuccess(@Nullable List<Void> result) {
                if (returnCodeFuture != null) {
                    returnCodeFuture.set((Object)PublishReturnCode.DELIVERED);
                }
            }

            public void onFailure(@NotNull Throwable throwable) {
                Exceptions.rethrowError("Unable to publish message for topic " + publish.getTopic() + " with message id" + publish.getUniqueId() + ".", throwable);
                if (returnCodeFuture != null) {
                    returnCodeFuture.set((Object)PublishReturnCode.FAILED);
                }
            }
        }, (Executor)executorService);
    }
}

