/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence.clientsession;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.hivemq.bootstrap.ClientConnection;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extensions.iteration.ChunkCursor;
import com.hivemq.extensions.iteration.Chunker;
import com.hivemq.extensions.iteration.MultipleChunkResult;
import com.hivemq.logging.EventLog;
import com.hivemq.mqtt.handler.disconnect.MqttServerDisconnector;
import com.hivemq.mqtt.message.connect.MqttWillPublish;
import com.hivemq.mqtt.message.reason.Mqtt5DisconnectReasonCode;
import com.hivemq.persistence.AbstractPersistence;
import com.hivemq.persistence.ProducerQueues;
import com.hivemq.persistence.SingleWriterService;
import com.hivemq.persistence.clientqueue.ClientQueuePersistence;
import com.hivemq.persistence.clientsession.ClientSession;
import com.hivemq.persistence.clientsession.ClientSessionPersistence;
import com.hivemq.persistence.clientsession.ClientSessionSubscriptionPersistence;
import com.hivemq.persistence.clientsession.ClientSessionWill;
import com.hivemq.persistence.clientsession.ConnectResult;
import com.hivemq.persistence.clientsession.PendingWillMessages;
import com.hivemq.persistence.clientsession.task.ClientSessionCleanUpTask;
import com.hivemq.persistence.connection.ConnectionPersistence;
import com.hivemq.persistence.local.ClientSessionLocalPersistence;
import com.hivemq.persistence.payload.PublishPayloadPersistence;
import com.hivemq.persistence.util.FutureUtils;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LazySingleton
public class ClientSessionPersistenceImpl
extends AbstractPersistence
implements ClientSessionPersistence {
    private static final Logger log = LoggerFactory.getLogger(ClientSessionPersistenceImpl.class);
    @NotNull
    private final ClientSessionLocalPersistence localPersistence;
    @NotNull
    private final ClientSessionSubscriptionPersistence subscriptionPersistence;
    @NotNull
    private final ClientQueuePersistence clientQueuePersistence;
    @NotNull
    private final ProducerQueues singleWriter;
    @NotNull
    private final ConnectionPersistence connectionPersistence;
    @NotNull
    private final EventLog eventLog;
    @NotNull
    private final PendingWillMessages pendingWillMessages;
    @NotNull
    private final MqttServerDisconnector mqttServerDisconnector;
    @NotNull
    private final Chunker chunker;

    @Inject
    public ClientSessionPersistenceImpl(@NotNull ClientSessionLocalPersistence localPersistence, @NotNull ClientSessionSubscriptionPersistence sessionSubscriptionPersistence, @NotNull ClientQueuePersistence clientQueuePersistence, @NotNull SingleWriterService singleWriterService, @NotNull ConnectionPersistence connectionPersistence, @NotNull EventLog eventLog, @NotNull PendingWillMessages pendingWillMessages, @NotNull MqttServerDisconnector mqttServerDisconnector, @NotNull Chunker chunker) {
        this.localPersistence = localPersistence;
        this.clientQueuePersistence = clientQueuePersistence;
        this.connectionPersistence = connectionPersistence;
        this.eventLog = eventLog;
        this.pendingWillMessages = pendingWillMessages;
        this.mqttServerDisconnector = mqttServerDisconnector;
        this.chunker = chunker;
        this.subscriptionPersistence = sessionSubscriptionPersistence;
        this.singleWriter = singleWriterService.getClientSessionQueue();
    }

    @Override
    public boolean isExistent(@NotNull String client) {
        Preconditions.checkNotNull((Object)client, (Object)"Client id must not be null");
        return ClientSessionPersistenceImpl.isExistent(this.getSession(client, false));
    }

    @Override
    @NotNull
    public Map<String, Boolean> isExistent(@NotNull Set<String> clients) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String client : clients) {
            builder.put((Object)client, (Object)this.isExistent(client));
        }
        return builder.build();
    }

    @Override
    @NotNull
    public ListenableFuture<Void> clientDisconnected(@NotNull String client, boolean sendWill, long sessionExpiry) {
        Preconditions.checkNotNull((Object)client, (Object)"Client id must not be null");
        long timestamp = System.currentTimeMillis();
        SettableFuture resultFuture = SettableFuture.create();
        this.singleWriter.submit(client, bucketIndex -> {
            ClientSession disconnectSession = this.localPersistence.disconnect(client, timestamp, sendWill, bucketIndex, sessionExpiry);
            if (sendWill) {
                this.pendingWillMessages.sendOrEnqueueWillIfAvailable(client, disconnectSession);
            }
            ListenableFuture<Void> removeQos0Future = this.clientQueuePersistence.removeAllQos0Messages(client, false);
            if (disconnectSession.getSessionExpiryIntervalSec() == 0L) {
                ListenableFuture<Void> removeSubFuture = this.subscriptionPersistence.removeAll(client);
                resultFuture.setFuture(Futures.transform((ListenableFuture)Futures.allAsList((ListenableFuture[])new ListenableFuture[]{removeQos0Future, removeSubFuture}), voids -> null, (Executor)MoreExecutors.directExecutor()));
                return null;
            }
            resultFuture.setFuture(removeQos0Future);
            return null;
        });
        return resultFuture;
    }

    @Override
    @NotNull
    public ListenableFuture<Void> clientConnected(final @NotNull String client, final boolean cleanStart, long clientSessionExpiryInterval, @Nullable MqttWillPublish willPublish, @Nullable Long queueLimit) {
        Preconditions.checkNotNull((Object)client, (Object)"Client id must not be null");
        long timestamp = System.currentTimeMillis();
        ClientSessionWill sessionWill = null;
        if (willPublish != null) {
            long publishId = PublishPayloadPersistence.createId();
            sessionWill = new ClientSessionWill(willPublish, publishId);
        }
        ClientSession clientSession = new ClientSession(true, clientSessionExpiryInterval, sessionWill, queueLimit);
        ListenableFuture<ConnectResult> submitFuture = this.singleWriter.submit(client, bucketIndex -> {
            Long previousTimestamp = this.localPersistence.getTimestamp(client, bucketIndex);
            ClientSession previousClientSession = this.localPersistence.getSession(client, bucketIndex, false);
            this.localPersistence.put(client, clientSession, timestamp, bucketIndex);
            return new ConnectResult(previousTimestamp, previousClientSession);
        });
        final SettableFuture resultFuture = SettableFuture.create();
        Futures.addCallback(submitFuture, (FutureCallback)new FutureCallback<ConnectResult>(){

            public void onSuccess(ConnectResult connectResult) {
                ListenableFuture<Void> cleanupFuture;
                Long previousTimestamp = connectResult.getPreviousTimestamp();
                ClientSession previousClientSession = connectResult.getPreviousClientSession();
                if (cleanStart) {
                    ClientSessionPersistenceImpl.this.pendingWillMessages.sendWillIfPending(client, previousClientSession);
                } else {
                    ClientSessionPersistenceImpl.this.pendingWillMessages.cancelWillIfPending(client);
                }
                if (cleanStart) {
                    cleanupFuture = ClientSessionPersistenceImpl.this.cleanClientData(client);
                } else {
                    boolean expired;
                    boolean bl = expired = previousTimestamp != null && previousClientSession.isExpired(System.currentTimeMillis() - previousTimestamp);
                    if (expired) {
                        ClientSessionPersistenceImpl.this.eventLog.clientSessionExpired(previousTimestamp + previousClientSession.getSessionExpiryIntervalSec() * 1000L, client);
                        cleanupFuture = ClientSessionPersistenceImpl.this.cleanClientData(client);
                    } else {
                        cleanupFuture = Futures.immediateFuture(null);
                    }
                }
                resultFuture.setFuture((ListenableFuture)cleanupFuture);
            }

            public void onFailure(@NotNull Throwable t) {
                resultFuture.setException(t);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return resultFuture;
    }

    @Override
    @NotNull
    public ListenableFuture<Boolean> forceDisconnectClient(@NotNull String clientId, boolean preventLwtMessage, @NotNull DisconnectSource source, @Nullable Mqtt5DisconnectReasonCode reasonCode, @Nullable String reasonString) {
        Preconditions.checkNotNull((Object)clientId, (Object)"Parameter clientId cannot be null");
        Preconditions.checkNotNull((Object)((Object)source), (Object)"Disconnect source cannot be null");
        ClientSession session = this.getSession(clientId, false);
        if (session == null) {
            log.trace("Ignoring forced client disconnect request for client '{}', because client is not connected.", (Object)clientId);
            return Futures.immediateFuture((Object)false);
        }
        if (preventLwtMessage) {
            this.pendingWillMessages.cancelWillIfPending(clientId);
        }
        log.debug("Request forced client disconnect for client {}.", (Object)clientId);
        ClientConnection clientConnection = this.connectionPersistence.get(clientId);
        if (clientConnection == null) {
            log.trace("Ignoring forced client disconnect request for client '{}', because client is not connected.", (Object)clientId);
            return Futures.immediateFuture((Object)false);
        }
        clientConnection.setPreventLwt(preventLwtMessage);
        if (session.getSessionExpiryIntervalSec() != Long.MAX_VALUE) {
            clientConnection.setClientSessionExpiryInterval(session.getSessionExpiryIntervalSec());
        }
        String logMessage = String.format("Disconnecting client with clientId '%s' forcibly via extension system.", clientId);
        String eventLogMessage = "Disconnected via extension system";
        Mqtt5DisconnectReasonCode usedReasonCode = reasonCode == null ? Mqtt5DisconnectReasonCode.ADMINISTRATIVE_ACTION : Mqtt5DisconnectReasonCode.valueOf(reasonCode.name());
        this.mqttServerDisconnector.disconnect(clientConnection.getChannel(), logMessage, "Disconnected via extension system", usedReasonCode, reasonString);
        SettableFuture resultFuture = SettableFuture.create();
        clientConnection.getChannel().closeFuture().addListener((GenericFutureListener)((ChannelFutureListener)future -> resultFuture.set((Object)true)));
        return resultFuture;
    }

    @Override
    @NotNull
    public ListenableFuture<Boolean> forceDisconnectClient(@NotNull String clientId, boolean preventLwtMessage, @NotNull DisconnectSource source) {
        return this.forceDisconnectClient(clientId, preventLwtMessage, source, null, null);
    }

    @Override
    @NotNull
    public ListenableFuture<Void> cleanClientData(@NotNull String clientId) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add(this.subscriptionPersistence.removeAll(clientId));
        builder.add(this.clientQueuePersistence.clear(clientId, false));
        return FutureUtils.voidFutureFromList((ImmutableList<ListenableFuture<Void>>)builder.build());
    }

    @Override
    @NotNull
    public ListenableFuture<Set<String>> getAllClients() {
        List<ListenableFuture<Set>> futures = this.singleWriter.submitToAllBucketsParallel(bucketIndex -> {
            HashSet<String> clientSessions = new HashSet<String>();
            clientSessions.addAll(this.localPersistence.getAllClients(bucketIndex));
            return clientSessions;
        });
        return Futures.transform((ListenableFuture)Futures.allAsList(futures), sets -> sets.stream().flatMap(Collection::stream).collect(Collectors.toSet()), (Executor)MoreExecutors.directExecutor());
    }

    @Override
    @Nullable
    public ClientSession getSession(@NotNull String clientId, boolean includeWill) {
        Preconditions.checkNotNull((Object)clientId, (Object)"Client id must not be null");
        return this.localPersistence.getSession(clientId, true, includeWill);
    }

    @Override
    @NotNull
    public ListenableFuture<Boolean> setSessionExpiryInterval(final @NotNull String clientId, final long sessionExpiryInterval) {
        Preconditions.checkNotNull((Object)clientId, (Object)"Client id must not be null");
        ListenableFuture<Boolean> setTTlFuture = this.singleWriter.submit(clientId, bucketIndex -> {
            boolean clientSessionExists;
            boolean bl = clientSessionExists = this.localPersistence.getSession(clientId) != null;
            if (!clientSessionExists) {
                return false;
            }
            this.localPersistence.setSessionExpiryInterval(clientId, sessionExpiryInterval, bucketIndex);
            return true;
        });
        final SettableFuture settableFuture = SettableFuture.create();
        Futures.addCallback(setTTlFuture, (FutureCallback)new FutureCallback<Boolean>(){

            public void onSuccess(final @Nullable Boolean sessionExists) {
                if (sessionExpiryInterval == 0L) {
                    ListenableFuture<Void> removeAllFuture = ClientSessionPersistenceImpl.this.subscriptionPersistence.removeAll(clientId);
                    Futures.addCallback(removeAllFuture, (FutureCallback)new FutureCallback<Void>(){

                        public void onSuccess(@Nullable Void result) {
                            settableFuture.set((Object)sessionExists);
                        }

                        public void onFailure(@NotNull Throwable t) {
                            settableFuture.setException(t);
                        }
                    }, (Executor)MoreExecutors.directExecutor());
                } else {
                    settableFuture.set((Object)sessionExists);
                }
            }

            public void onFailure(@NotNull Throwable t) {
                settableFuture.setException(t);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return settableFuture;
    }

    @Override
    @Nullable
    public Long getSessionExpiryInterval(@NotNull String clientId) {
        ClientSession session = this.getSession(clientId, false);
        if (session == null) {
            return null;
        }
        return session.getSessionExpiryIntervalSec();
    }

    @Override
    @NotNull
    public ListenableFuture<Void> cleanUp(int bucketIndex) {
        return this.singleWriter.submit(bucketIndex, new ClientSessionCleanUpTask(this.localPersistence, this, this.pendingWillMessages));
    }

    @Override
    @NotNull
    public ListenableFuture<Void> closeDB() {
        return this.closeDB(this.localPersistence, this.singleWriter);
    }

    @Override
    @NotNull
    public ListenableFuture<Boolean> invalidateSession(final @NotNull String clientId, final @NotNull DisconnectSource disconnectSource) {
        Preconditions.checkNotNull((Object)clientId, (Object)"ClientId cannot be null");
        Preconditions.checkNotNull((Object)((Object)disconnectSource), (Object)"Disconnect source cannot be null");
        ListenableFuture<Boolean> setTTLFuture = this.setSessionExpiryInterval(clientId, 0L);
        final SettableFuture resultFuture = SettableFuture.create();
        Futures.addCallback(setTTLFuture, (FutureCallback)new FutureCallback<Boolean>(){

            public void onSuccess(Boolean sessionExists) {
                if (sessionExists.booleanValue()) {
                    ListenableFuture<Boolean> disconnectClientFuture = ClientSessionPersistenceImpl.this.forceDisconnectClient(clientId, false, disconnectSource);
                    resultFuture.setFuture(disconnectClientFuture);
                } else {
                    resultFuture.set(null);
                }
            }

            public void onFailure(@NotNull Throwable throwable) {
                resultFuture.setException(throwable);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return resultFuture;
    }

    @Override
    @NotNull
    public ListenableFuture<Map<String, PendingWillMessages.PendingWill>> pendingWills() {
        List<ListenableFuture<Map>> futureList = this.singleWriter.submitToAllBucketsParallel(this.localPersistence::getPendingWills);
        final SettableFuture settableFuture = SettableFuture.create();
        Futures.addCallback((ListenableFuture)Futures.allAsList(futureList), (FutureCallback)new FutureCallback<List<Map<String, PendingWillMessages.PendingWill>>>(){

            public void onSuccess(@Nullable List<Map<String, PendingWillMessages.PendingWill>> result) {
                if (result == null) {
                    settableFuture.set((Object)ImmutableMap.of());
                    return;
                }
                ImmutableMap.Builder resultMap = ImmutableMap.builder();
                for (Map<String, PendingWillMessages.PendingWill> map : result) {
                    resultMap.putAll(map);
                }
                settableFuture.set((Object)resultMap.build());
            }

            public void onFailure(Throwable t) {
                settableFuture.setException(t);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return settableFuture;
    }

    @Override
    @NotNull
    public ListenableFuture<Void> deleteWill(@NotNull String clientId) {
        Preconditions.checkNotNull((Object)clientId, (Object)"Client id must not be null");
        return this.singleWriter.submit(clientId, bucketIndex -> {
            this.localPersistence.deleteWill(clientId, bucketIndex);
            return null;
        });
    }

    @Override
    @NotNull
    public ListenableFuture<MultipleChunkResult<Map<String, ClientSession>>> getAllLocalClientsChunk(@NotNull ChunkCursor cursor) {
        return this.chunker.getAllLocalChunk(cursor, 2000, (bucket, lastKey, maxResults) -> this.singleWriter.submit(bucket, bucketIndex -> this.localPersistence.getAllClientsChunk(bucketIndex, lastKey, maxResults)));
    }

    private static boolean isExistent(@Nullable ClientSession clientSession) {
        return clientSession != null && (clientSession.getSessionExpiryIntervalSec() > 0L || clientSession.isConnected());
    }

    public static enum DisconnectSource {
        EXTENSION(0);

        final int number;

        private DisconnectSource(int number) {
            this.number = number;
        }

        public int getNumber() {
            return this.number;
        }
    }
}

