/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence.connection;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.hivemq.bootstrap.ClientConnection;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.persistence.connection.ConnectionPersistence;
import com.hivemq.util.Exceptions;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ConnectionPersistenceImpl
implements ConnectionPersistence {
    private static final Logger log = LoggerFactory.getLogger(ConnectionPersistenceImpl.class);
    @NotNull
    private final Map<String, ClientConnection> clientConnectionMap;
    @NotNull
    private final Map<String, Channel> serverChannelMap;
    @NotNull
    private final AtomicBoolean interrupted = new AtomicBoolean(false);
    private final boolean shutdownLegacy;
    private final int shutdownPartitionSize;

    @Inject
    public ConnectionPersistenceImpl() {
        this.shutdownLegacy = false;
        this.shutdownPartitionSize = 100;
        this.clientConnectionMap = new ConcurrentHashMap<String, ClientConnection>();
        this.serverChannelMap = new ConcurrentHashMap<String, Channel>();
    }

    @Override
    @Nullable
    public ClientConnection get(@NotNull String clientId) {
        return this.clientConnectionMap.get(clientId);
    }

    @Override
    @NotNull
    public ClientConnection persistIfAbsent(@NotNull ClientConnection clientConnection) {
        return this.clientConnectionMap.computeIfAbsent(clientConnection.getClientId(), id -> clientConnection);
    }

    @Override
    public void remove(@NotNull ClientConnection clientConnection) {
        this.clientConnectionMap.remove(clientConnection.getClientId(), clientConnection);
    }

    @Override
    public void addServerChannel(@NotNull String listenerName, @NotNull Channel channel) {
        this.serverChannelMap.put(listenerName, channel);
    }

    @Override
    public void interruptShutdown() {
        this.interrupted.set(true);
    }

    @Override
    @NotNull
    public ListenableFuture<Void> shutDown() {
        if (this.shutdownLegacy) {
            return Futures.immediateFuture(null);
        }
        ListenableFuture<Void> allServersClosedFuture = this.shutDownListeners();
        final SettableFuture allClientsClosedFuture = SettableFuture.create();
        Futures.addCallback(allServersClosedFuture, (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(@Nullable Void result) {
                ConnectionPersistenceImpl.this.shutDownClients((SettableFuture<Void>)allClientsClosedFuture);
            }

            public void onFailure(@NotNull Throwable t) {
                Exceptions.rethrowError(t);
                log.warn("Shutdown of listeners failed");
                if (log.isDebugEnabled()) {
                    log.debug("Original Exception: ", t);
                }
                ConnectionPersistenceImpl.this.shutDownClients((SettableFuture<Void>)allClientsClosedFuture);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return allClientsClosedFuture;
    }

    @NotNull
    private ListenableFuture<Void> shutDownListeners() {
        try {
            ImmutableMap allServerChannels = ImmutableMap.copyOf(this.serverChannelMap);
            ImmutableList.Builder futureBuilder = ImmutableList.builder();
            for (Map.Entry channelEntry : allServerChannels.entrySet()) {
                SettableFuture closeFuture = SettableFuture.create();
                futureBuilder.add((Object)closeFuture);
                ((Channel)channelEntry.getValue()).close().addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                    log.debug("Closed channel of listener with name '{}'", channelEntry.getKey());
                    closeFuture.set(null);
                }));
            }
            ListenableFuture future2 = Futures.allAsList((Iterable)futureBuilder.build());
            final SettableFuture resultFuture = SettableFuture.create();
            Futures.addCallback((ListenableFuture)future2, (FutureCallback)new FutureCallback<List<Void>>(){

                public void onSuccess(@Nullable List<Void> result) {
                    resultFuture.set(null);
                }

                public void onFailure(@NotNull Throwable t) {
                    resultFuture.setException(t);
                }
            }, (Executor)MoreExecutors.directExecutor());
            return resultFuture;
        }
        catch (Exception e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    private void shutDownClients(@NotNull SettableFuture<Void> allClientsClosedFuture) {
        ArrayList<ClientConnection> allConnections = new ArrayList<ClientConnection>(this.clientConnectionMap.values());
        if (allConnections.isEmpty()) {
            allClientsClosedFuture.set(null);
            return;
        }
        List connectionPartitions = Lists.partition(allConnections, (int)this.shutdownPartitionSize);
        this.shutDownPartition(connectionPartitions, 0, allClientsClosedFuture);
    }

    private void shutDownPartition(@NotNull List<List<ClientConnection>> connectionPartitions, int index, @NotNull SettableFuture<Void> closeFuture) {
        if (this.interrupted.get() || index >= connectionPartitions.size()) {
            closeFuture.set(null);
            return;
        }
        List<ClientConnection> partition = connectionPartitions.get(index);
        ArrayList<Object> closeFutures = new ArrayList<Object>(partition.size());
        for (ClientConnection clientConnection : partition) {
            SettableFuture<Void> disconnectFuture = clientConnection.getDisconnectFuture();
            ChannelFuture channelFuture = clientConnection.getChannel().close();
            if (disconnectFuture != null) {
                closeFutures.add(disconnectFuture);
                continue;
            }
            SettableFuture channelCloseFuture = SettableFuture.create();
            closeFutures.add(channelCloseFuture);
            channelFuture.addListener((GenericFutureListener)((ChannelFutureListener)future -> channelCloseFuture.set(null)));
        }
        Futures.whenAllComplete(closeFutures).run(() -> this.shutDownPartition(connectionPartitions, index + 1, closeFuture), MoreExecutors.directExecutor());
    }

    @VisibleForTesting
    @NotNull
    public Set<Map.Entry<String, ClientConnection>> entries() {
        return this.clientConnectionMap.entrySet();
    }
}

