/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence.ioc;

import com.hivemq.bootstrap.ioc.SingletonModule;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.migration.meta.PersistenceType;
import com.hivemq.persistence.local.xodus.RetainedMessageRocksDBLocalPersistence;
import com.hivemq.persistence.payload.PublishPayloadLocalPersistence;
import com.hivemq.persistence.payload.PublishPayloadRocksDBLocalPersistence;
import com.hivemq.persistence.retained.RetainedMessageLocalPersistence;
import javax.inject.Singleton;

class PersistenceMigrationRocksDBModule
extends SingletonModule<Class<PersistenceMigrationRocksDBModule>> {
    @NotNull
    private final PersistenceType payloadPersistenceType = InternalConfigurations.PAYLOAD_PERSISTENCE_TYPE.get();
    @NotNull
    private final PersistenceType retainedPersistenceType = InternalConfigurations.RETAINED_MESSAGE_PERSISTENCE_TYPE.get();

    PersistenceMigrationRocksDBModule() {
        super(PersistenceMigrationRocksDBModule.class);
    }

    protected void configure() {
        if (this.retainedPersistenceType == PersistenceType.FILE_NATIVE) {
            this.bind(RetainedMessageLocalPersistence.class).to(RetainedMessageRocksDBLocalPersistence.class).in(Singleton.class);
        }
        if (this.payloadPersistenceType == PersistenceType.FILE_NATIVE) {
            this.bind(PublishPayloadLocalPersistence.class).to(PublishPayloadRocksDBLocalPersistence.class).in(Singleton.class);
        }
    }
}

