/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence.ioc;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.hivemq.bootstrap.ioc.SingletonModule;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.common.shutdown.ShutdownHooks;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.configuration.service.PersistenceConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.mqtt.topic.tree.TopicTreeStartup;
import com.hivemq.persistence.InMemorySingleWriter;
import com.hivemq.persistence.PersistenceShutdownHookInstaller;
import com.hivemq.persistence.ScheduledCleanUpService;
import com.hivemq.persistence.SingleWriterService;
import com.hivemq.persistence.SingleWriterServiceImpl;
import com.hivemq.persistence.ioc.LocalPersistenceModule;
import com.hivemq.persistence.ioc.annotation.PayloadPersistence;
import com.hivemq.persistence.ioc.annotation.Persistence;
import com.hivemq.persistence.ioc.provider.local.PayloadPersistenceScheduledExecutorProvider;
import com.hivemq.persistence.ioc.provider.local.PersistenceExecutorProvider;
import com.hivemq.persistence.ioc.provider.local.PersistenceScheduledExecutorProvider;
import com.hivemq.persistence.util.FutureUtils;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;

public class PersistenceModule
extends SingletonModule<Class<PersistenceModule>> {
    @NotNull
    private final Injector persistenceInjector;
    private final PersistenceConfigurationService persistenceConfigurationService;

    public PersistenceModule(@NotNull Injector persistenceInjector, PersistenceConfigurationService persistenceConfigurationService) {
        super(PersistenceModule.class);
        this.persistenceInjector = persistenceInjector;
        this.persistenceConfigurationService = persistenceConfigurationService;
    }

    protected void configure() {
        this.install((Module)new LocalPersistenceModule(this.persistenceInjector, this.persistenceConfigurationService));
        if (this.persistenceConfigurationService.getMode() == PersistenceConfigurationService.PersistenceMode.IN_MEMORY && InternalConfigurations.IN_MEMORY_SINGLE_WRITER.get()) {
            this.bind(SingleWriterService.class).to(InMemorySingleWriter.class);
        } else {
            this.bind(SingleWriterService.class).to(SingleWriterServiceImpl.class);
        }
        this.bind(ShutdownHooks.class).toInstance((Object)((ShutdownHooks)this.persistenceInjector.getInstance(ShutdownHooks.class)));
        this.bind(PersistenceShutdownHookInstaller.class).asEagerSingleton();
        this.bind(ExecutorService.class).annotatedWith(Persistence.class).toProvider(PersistenceExecutorProvider.class).in(LazySingleton.class);
        this.bind(ListeningExecutorService.class).annotatedWith(Persistence.class).toProvider(PersistenceExecutorProvider.class).in(LazySingleton.class);
        this.bind(ScheduledExecutorService.class).annotatedWith(Persistence.class).toProvider(PersistenceScheduledExecutorProvider.class).in(LazySingleton.class);
        this.bind(ListeningScheduledExecutorService.class).annotatedWith(Persistence.class).toProvider(PersistenceScheduledExecutorProvider.class).in(LazySingleton.class);
        this.bindIfAbsent(ListeningScheduledExecutorService.class, PayloadPersistenceScheduledExecutorProvider.class, PayloadPersistence.class);
        this.bind(TopicTreeStartup.class).asEagerSingleton();
        this.bind(ScheduledCleanUpService.class).asEagerSingleton();
        this.requestStaticInjection(new Class[]{FutureUtils.class});
    }

    private <T> void bindIfAbsent(Class type, Class provider, Class annotation) {
        Object instance = this.persistenceInjector.getInstance(Key.get((Class)type, (Class)annotation));
        if (instance != null) {
            this.bind(type).annotatedWith(annotation).toInstance(instance);
        } else {
            this.bind(type).annotatedWith(annotation).toProvider(provider).in(LazySingleton.class);
        }
    }
}

