/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence.ioc.provider.local;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.persistence.ioc.annotation.Persistence;
import com.hivemq.util.ThreadFactoryUtil;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.inject.Provider;

@LazySingleton
public class PersistenceExecutorProvider
implements Provider<ListeningExecutorService> {
    @Nullable
    private ListeningExecutorService executorService;

    @Persistence
    @NotNull
    public ListeningExecutorService get() {
        if (this.executorService == null) {
            ThreadFactory threadFactory = ThreadFactoryUtil.create("persistence-executor");
            ExecutorService singleThreadExecutor = Executors.newSingleThreadExecutor(threadFactory);
            this.executorService = MoreExecutors.listeningDecorator((ExecutorService)singleThreadExecutor);
        }
        return this.executorService;
    }
}

