/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence.local.rocksdb;

import com.google.common.base.Preconditions;
import com.hivemq.exceptions.UnrecoverableException;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.persistence.FilePersistence;
import com.hivemq.persistence.LocalPersistence;
import com.hivemq.persistence.PersistenceStartup;
import com.hivemq.persistence.local.xodus.bucket.BucketUtils;
import com.hivemq.util.LocalPersistenceFileUtil;
import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.Cache;
import org.rocksdb.LRUCache;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.Statistics;
import org.rocksdb.TableFormatConfig;
import org.slf4j.Logger;

public abstract class RocksDBLocalPersistence
implements LocalPersistence,
FilePersistence {
    protected final AtomicBoolean stopped = new AtomicBoolean(false);
    @NotNull
    protected final RocksDB[] buckets;
    @NotNull
    private final LocalPersistenceFileUtil localPersistenceFileUtil;
    @NotNull
    private final PersistenceStartup persistenceStartup;
    private final int bucketCount;
    private final int memTableSizePortion;
    private final int blockCacheSizePortion;
    private final int blockSize;
    private final boolean enabled;

    protected RocksDBLocalPersistence(@NotNull LocalPersistenceFileUtil localPersistenceFileUtil, @NotNull PersistenceStartup persistenceStartup, int bucketCount, int memTableSizePortion, int blockCacheSizePortion, int blockSize, boolean enabled) {
        this.localPersistenceFileUtil = localPersistenceFileUtil;
        this.persistenceStartup = persistenceStartup;
        this.bucketCount = bucketCount;
        this.buckets = new RocksDB[bucketCount];
        this.memTableSizePortion = memTableSizePortion;
        this.blockCacheSizePortion = blockCacheSizePortion;
        this.blockSize = blockSize;
        this.enabled = enabled;
    }

    @NotNull
    protected abstract String getName();

    @NotNull
    protected abstract String getVersion();

    @NotNull
    protected abstract Logger getLogger();

    public int getBucketCount() {
        return this.bucketCount;
    }

    protected void postConstruct() {
        RocksDB.loadLibrary();
        if (this.enabled) {
            this.persistenceStartup.submitPersistenceStart(this);
        } else {
            this.startExternal();
        }
    }

    @Override
    public void startExternal() {
        String name = this.getName();
        String version = this.getVersion();
        Options options = new Options();
        Logger logger = this.getLogger();
        try {
            File persistenceFolder = this.localPersistenceFileUtil.getVersionedLocalPersistenceFolder(name, version);
            long memTableSize = RocksDBLocalPersistence.physicalMemory() / (long)this.memTableSizePortion / (long)this.bucketCount;
            LRUCache cache = new LRUCache(RocksDBLocalPersistence.physicalMemory() / (long)this.blockCacheSizePortion / (long)this.bucketCount);
            BlockBasedTableConfig tableConfig = new BlockBasedTableConfig();
            tableConfig.setBlockCache((Cache)cache);
            tableConfig.setBlockSize((long)this.blockSize);
            options.setStatistics(new Statistics());
            options.setCreateIfMissing(true);
            options.setTableFormatConfig((TableFormatConfig)tableConfig);
            options.setWriteBufferSize(memTableSize);
            options.setStatsPersistPeriodSec(0);
            options.setStatsDumpPeriodSec(0);
            options.setMaxLogFileSize(512000L);
            options.setKeepLogFileNum(2L);
            options.setStatsHistoryBufferSize(65536L);
            for (int i = 0; i < this.bucketCount; ++i) {
                RocksDB rocksDB;
                File persistenceFile = new File(persistenceFolder, name + "_" + i);
                this.buckets[i] = rocksDB = RocksDB.open((Options)options, (String)persistenceFile.getAbsolutePath());
            }
        }
        catch (RocksDBException e) {
            logger.error("An error occurred while opening the {} persistence. Is another HiveMQ instance running?", (Object)name);
            logger.info("Original Exception:", (Throwable)e);
            throw new UnrecoverableException();
        }
        this.init();
    }

    @Override
    public void start() {
        String name = this.getName();
        String version = this.getVersion();
        Options options = new Options();
        Logger logger = this.getLogger();
        try {
            long memTableSize = RocksDBLocalPersistence.physicalMemory() / (long)this.memTableSizePortion / (long)this.bucketCount;
            long blockCacheMaxSize = RocksDBLocalPersistence.physicalMemory() / (long)this.blockCacheSizePortion;
            LRUCache cache = new LRUCache(blockCacheMaxSize);
            BlockBasedTableConfig tableConfig = new BlockBasedTableConfig();
            tableConfig.setBlockCache((Cache)cache);
            tableConfig.setBlockSize((long)this.blockSize);
            options.setStatistics(new Statistics());
            options.setCreateIfMissing(true);
            options.setTableFormatConfig((TableFormatConfig)tableConfig);
            options.setWriteBufferSize(memTableSize);
            options.setStatsPersistPeriodSec(0);
            options.setStatsDumpPeriodSec(0);
            options.setMaxLogFileSize(512000L);
            options.setKeepLogFileNum(2L);
            options.setStatsHistoryBufferSize(65536L);
            File persistenceFolder = this.localPersistenceFileUtil.getVersionedLocalPersistenceFolder(name, version);
            CountDownLatch counter = new CountDownLatch(this.bucketCount);
            int i = 0;
            while (i < this.bucketCount) {
                int finalI = i++;
                this.persistenceStartup.submitEnvironmentCreate(() -> {
                    try {
                        RocksDB rocksDB;
                        File persistenceFile = new File(persistenceFolder, name + "_" + finalI);
                        this.buckets[finalI] = rocksDB = RocksDB.open((Options)options, (String)persistenceFile.getAbsolutePath());
                        counter.countDown();
                    }
                    catch (Exception e) {
                        logger.error("An error occurred while opening the {} persistence. Is another HiveMQ instance running?", (Object)name);
                        logger.info("Original Exception:", (Throwable)e);
                        throw new UnrecoverableException();
                    }
                });
            }
            counter.await();
        }
        catch (Exception e) {
            logger.error("An error occurred while opening the {} persistence. Is another HiveMQ instance running?", (Object)name);
            logger.info("Original Exception:", (Throwable)e);
            throw new UnrecoverableException();
        }
        this.init();
    }

    protected static long physicalMemory() {
        OperatingSystemMXBean sunBeam;
        long physicalMemory;
        java.lang.management.OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        if (operatingSystemMXBean instanceof OperatingSystemMXBean && (physicalMemory = (sunBeam = (OperatingSystemMXBean)operatingSystemMXBean).getTotalPhysicalMemorySize()) > 0L) {
            return physicalMemory;
        }
        long heap = Runtime.getRuntime().maxMemory();
        double fallbackEstimation = 1.5;
        return (long)((double)heap * 1.5);
    }

    protected void configureOptions(@NotNull Options options) {
    }

    protected abstract void init();

    @Override
    public void stop() {
        this.stopped.set(true);
        this.closeDB();
    }

    public void closeDB() {
        for (int i = 0; i < this.bucketCount; ++i) {
            this.closeDB(i);
        }
    }

    @Override
    public void closeDB(int bucketIndex) {
        this.checkBucketIndex(bucketIndex);
        RocksDB bucket = this.buckets[bucketIndex];
        bucket.close();
    }

    @NotNull
    protected RocksDB getRocksDb(@NotNull String key) {
        return this.buckets[BucketUtils.getBucket(key, this.bucketCount)];
    }

    protected int getBucketIndex(@NotNull String key) {
        return BucketUtils.getBucket(key, this.bucketCount);
    }

    protected void checkBucketIndex(int bucketIndex) {
        Preconditions.checkArgument((bucketIndex >= 0 && bucketIndex < this.buckets.length ? 1 : 0) != 0, (Object)("Invalid bucket index: " + bucketIndex));
    }
}

