/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence.payload;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.inject.Inject;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.persistence.ioc.annotation.PayloadPersistence;
import com.hivemq.persistence.payload.BucketLock;
import com.hivemq.persistence.payload.PayloadReferenceCounterRegistry;
import com.hivemq.persistence.payload.PayloadReferenceCounterRegistryImpl;
import com.hivemq.persistence.payload.PublishPayloadLocalPersistence;
import com.hivemq.persistence.payload.PublishPayloadPersistence;
import com.hivemq.persistence.payload.RemovablePayloads;
import com.hivemq.persistence.payload.RemoveEntryTask;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LazySingleton
public class PublishPayloadPersistenceImpl
implements PublishPayloadPersistence {
    @NotNull
    private static final Logger log = LoggerFactory.getLogger(PublishPayloadPersistenceImpl.class);
    @NotNull
    private final PublishPayloadLocalPersistence localPersistence;
    @NotNull
    private final ListeningScheduledExecutorService scheduledExecutorService;
    @NotNull
    private final BucketLock bucketLock;
    @NotNull
    private final PayloadReferenceCounterRegistry payloadReferenceCounterRegistry;
    @NotNull
    private final RemovablePayloads[] removablePayloads;

    @Inject
    PublishPayloadPersistenceImpl(@NotNull PublishPayloadLocalPersistence localPersistence, @PayloadPersistence @NotNull ListeningScheduledExecutorService scheduledExecutorService) {
        this.localPersistence = localPersistence;
        this.scheduledExecutorService = scheduledExecutorService;
        int bucketCount = InternalConfigurations.PAYLOAD_PERSISTENCE_BUCKET_COUNT.get();
        this.bucketLock = new BucketLock(bucketCount);
        this.payloadReferenceCounterRegistry = new PayloadReferenceCounterRegistryImpl(this.bucketLock);
        this.removablePayloads = new RemovablePayloads[bucketCount];
        for (int i = 0; i < bucketCount; ++i) {
            this.removablePayloads[i] = new RemovablePayloads(i, new LinkedList<Long>());
        }
    }

    @Override
    public void init() {
        int cleanupThreadCount = InternalConfigurations.PAYLOAD_PERSISTENCE_CLEANUP_THREADS.get();
        long removeSchedule = InternalConfigurations.PAYLOAD_PERSISTENCE_CLEANUP_SCHEDULE_MSEC.get();
        RemovablePayloads[][] bucketResponsibilities = PublishPayloadPersistenceImpl.partitionBucketResponsibilities(this.removablePayloads, cleanupThreadCount);
        for (int i = 0; i < cleanupThreadCount; ++i) {
            RemovablePayloads[] responsibleBuckets = bucketResponsibilities[i];
            if (responsibleBuckets.length <= 0 || this.scheduledExecutorService.isShutdown()) continue;
            this.scheduledExecutorService.scheduleWithFixedDelay((Runnable)new RemoveEntryTask(this.bucketLock, this.payloadReferenceCounterRegistry, this.localPersistence, responsibleBuckets), removeSchedule, removeSchedule, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void add(byte @NotNull [] payload, long id) {
        Preconditions.checkNotNull((Object)payload, (Object)"Payload must not be null");
        this.bucketLock.accessBucketByPayloadId(id, bucketIndex -> {
            if (this.payloadReferenceCounterRegistry.getAndIncrement(id) == -1) {
                this.localPersistence.put(id, payload);
            }
        });
    }

    @Override
    public byte @Nullable [] get(long id) {
        return this.localPersistence.get(id);
    }

    @Override
    public void incrementReferenceCounterOnBootstrap(long id) {
        this.bucketLock.accessBucketByPayloadId(id, bucketIndex -> this.payloadReferenceCounterRegistry.getAndIncrement(id));
    }

    @Override
    public void decrementReferenceCounter(long id) {
        this.bucketLock.accessBucketByPayloadId(id, bucketIndex -> {
            int result = this.payloadReferenceCounterRegistry.decrementAndGet(id);
            if (result == -1 || result == -2) {
                log.warn("Tried to decrement a payload reference counter ({}) that was already zero.", (Object)id);
                if (log.isDebugEnabled()) {
                    log.debug("Original Exception:", (Throwable)new Exception());
                }
            } else if (result == 0) {
                this.removablePayloads[bucketIndex].getQueue().add(id);
            }
        });
    }

    @Override
    public void closeDB() {
        this.localPersistence.closeDB();
    }

    @VisibleForTesting
    @NotNull
    public ImmutableMap<Long, Integer> getReferenceCountersAsMap() {
        return ImmutableMap.copyOf(this.payloadReferenceCounterRegistry.getAll());
    }

    @VisibleForTesting
    @NotNull
    static @NotNull RemovablePayloads @NotNull [] @NotNull [] partitionBucketResponsibilities(@NotNull RemovablePayloads[] removablePayloads, int threads) {
        RemovablePayloads[][] responsibilities = new RemovablePayloads[threads][];
        int buckets = removablePayloads.length;
        int bucketsPerThread = buckets / threads;
        int remainingBuckets = buckets % threads;
        for (int i = 0; i < threads; ++i) {
            if (i < remainingBuckets) {
                responsibilities[i] = new RemovablePayloads[bucketsPerThread + 1];
                responsibilities[i][bucketsPerThread] = removablePayloads[buckets - 1 - i];
            } else {
                responsibilities[i] = new RemovablePayloads[bucketsPerThread];
            }
            int startIndex = i * bucketsPerThread;
            System.arraycopy(removablePayloads, startIndex, responsibilities[i], 0, bucketsPerThread);
        }
        return responsibilities;
    }
}

