/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.websocket;

import com.hivemq.bootstrap.ClientConnectionContext;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketTextFrameHandler
extends SimpleChannelInboundHandler<TextWebSocketFrame> {
    private static final Logger log = LoggerFactory.getLogger(WebSocketTextFrameHandler.class);

    protected void channelRead0(ChannelHandlerContext ctx, TextWebSocketFrame msg) throws Exception {
        Channel channel = ctx.channel();
        channel.disconnect();
        if (log.isDebugEnabled()) {
            ClientConnectionContext clientConnectionContext = ClientConnectionContext.of(channel);
            Optional<String> channelIP = clientConnectionContext.getChannelIP();
            log.debug("Sending websocket text frames is illegal, only binary frames are allowed for MQTT over websockets. Disconnecting client with IP{}.", channelIP);
        }
    }
}

