/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.user.connection.limits.config;

import java.time.Duration;
import java.util.Optional;
import org.apache.qpid.server.user.connection.limits.config.AbstractRule;
import org.apache.qpid.server.user.connection.limits.plugins.ConnectionLimitRule;

final class NonBlockingRule
extends AbstractRule {
    private final Integer _connectionCount;
    private final Integer _connectionFrequency;
    private Duration _frequencyPeriod;

    NonBlockingRule(ConnectionLimitRule rule) {
        this(rule.getPort(), rule.getIdentity(), rule.getCountLimit(), rule.getFrequencyLimit(), Optional.ofNullable(rule.getFrequencyPeriod()).map(Duration::ofMillis).orElse(null));
    }

    NonBlockingRule(String port, String identity, Integer connectionCount, Integer connectionFrequency, Duration frequencyPeriod) {
        super(port, identity);
        if (connectionCount == null && connectionFrequency == null) {
            throw new IllegalArgumentException("Empty connection limit rule");
        }
        this._connectionCount = connectionCount;
        this._connectionFrequency = connectionFrequency;
        this._frequencyPeriod = frequencyPeriod;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isUserBlocked() {
        return false;
    }

    @Override
    public Integer getCountLimit() {
        return this._connectionCount;
    }

    @Override
    public Integer getFrequencyLimit() {
        return this._connectionFrequency;
    }

    @Override
    public Duration getFrequencyPeriod() {
        return this._frequencyPeriod;
    }

    @Override
    public void updateWithDefaultFrequencyPeriod(Duration period) {
        if (this._frequencyPeriod == null) {
            this._frequencyPeriod = period;
        }
    }
}

