/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.factory.aasx;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.eclipse.basyx.aas.bundle.AASBundle;
import org.eclipse.basyx.aas.bundle.AASBundleFactory;
import org.eclipse.basyx.aas.factory.aasx.FileLoaderHelper;
import org.eclipse.basyx.aas.factory.exception.MultipleThumbnailFoundException;
import org.eclipse.basyx.aas.factory.xml.XMLToMetamodelConverter;
import org.eclipse.basyx.aas.metamodel.map.AasEnv;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElementCollection;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IFile;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class AASXToMetamodelConverter {
    private static final String XML_TYPE = "http://www.admin-shell.io/aasx/relationships/aas-spec";
    private static final String AASX_ORIGIN = "/aasx/aasx-origin";
    private String aasxPath;
    private OPCPackage aasxRoot;
    private InputStream aasxInputStream;
    private Set<AASBundle> bundles;
    private AasEnv aasEnv;
    private static Logger logger = LoggerFactory.getLogger(AASXToMetamodelConverter.class);

    public AASXToMetamodelConverter(String path) {
        this.aasxPath = path;
    }

    public AASXToMetamodelConverter(InputStream stream) {
        this.aasxInputStream = stream;
    }

    public AasEnv retrieveAasEnv() throws ParserConfigurationException, SAXException, IOException, InvalidFormatException {
        if (this.aasEnv != null) {
            return this.aasEnv;
        }
        this.loadAASX();
        String xmlContent = this.getXMLResourceString(this.aasxRoot);
        XMLToMetamodelConverter converter = new XMLToMetamodelConverter(xmlContent);
        this.closeOPCPackage();
        return converter.parseAasEnv();
    }

    public InputStream retrieveThumbnail() throws IOException, InvalidFormatException {
        this.loadAASX();
        InputStream thumbnailStream = this.getThumbnailStream(this.aasxRoot);
        this.closeOPCPackage();
        return thumbnailStream;
    }

    public <T extends AASBundle> Set<T> retrieveAASBundles() throws IOException, ParserConfigurationException, SAXException, InvalidFormatException {
        if (this.bundles != null) {
            return this.bundles;
        }
        this.loadAASX();
        AasEnv localAasEnv = this.retrieveAasEnv();
        this.bundles = new AASBundleFactory().create(localAasEnv.getAssetAdministrationShells(), localAasEnv.getSubmodels(), localAasEnv.getAssets());
        this.closeOPCPackage();
        return this.bundles;
    }

    private void loadAASX() throws IOException, InvalidFormatException {
        if (this.aasxInputStream == null) {
            this.aasxInputStream = FileLoaderHelper.getInputStream(this.aasxPath);
        }
        if (this.aasxRoot == null) {
            this.aasxRoot = OPCPackage.open((InputStream)this.aasxInputStream);
        }
    }

    private void closeOPCPackage() throws IOException {
        this.aasxRoot.close();
    }

    private String getXMLResourceString(OPCPackage aasxPackage) throws InvalidFormatException, IOException {
        PackagePart originPart = aasxPackage.getPart(PackagingURIHelper.createPartName((String)AASX_ORIGIN));
        PackageRelationshipCollection originRelationships = originPart.getRelationshipsByType(XML_TYPE);
        if (originRelationships.size() > 1) {
            throw new RuntimeException("More than one 'aasx-spec' document found in .aasx");
        }
        if (originRelationships.size() == 0) {
            throw new RuntimeException("No 'aasx-spec' document found in .aasx");
        }
        PackagePart xmlPart = originPart.getRelatedPart(originRelationships.getRelationship(0));
        InputStream stream = xmlPart.getInputStream();
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)stream, (Writer)writer, (Charset)StandardCharsets.UTF_8);
        return writer.toString();
    }

    private InputStream getThumbnailStream(OPCPackage aasxPackage) throws IOException {
        PackageRelationshipCollection thumbnailPackageRelationship = aasxPackage.getRelationshipsByType("http://schemas.openxmlformats.org/package/2006/relationships/metadata/thumbnail");
        this.checkIfThumbnailExists(thumbnailPackageRelationship);
        PackagePart thumbnailPart = aasxPackage.getPart(thumbnailPackageRelationship.getRelationship(0));
        return thumbnailPart.getInputStream();
    }

    private void checkIfThumbnailExists(PackageRelationshipCollection thumbnailPackageRelationship) throws MultipleThumbnailFoundException, FileNotFoundException {
        if (thumbnailPackageRelationship.size() > 1) {
            throw new MultipleThumbnailFoundException("More than one Thumbnail found in the specified package");
        }
        if (thumbnailPackageRelationship.size() == 0) {
            throw new FileNotFoundException("No Thumbnail found in the specified package");
        }
    }

    private List<String> parseReferencedFilePathsFromAASX() throws IOException, ParserConfigurationException, SAXException, InvalidFormatException {
        Set bundles = this.retrieveAASBundles();
        ArrayList<ISubmodel> submodels = new ArrayList<ISubmodel>();
        for (AASBundle bundle : bundles) {
            submodels.addAll(bundle.getSubmodels());
        }
        ArrayList<String> paths = new ArrayList<String>();
        for (ISubmodel sm : submodels) {
            paths.addAll(this.parseElements(sm.getSubmodelElements().values()));
        }
        return paths;
    }

    private List<String> parseElements(Collection<ISubmodelElement> elements) {
        ArrayList<String> paths = new ArrayList<String>();
        for (ISubmodelElement element : elements) {
            if (element instanceof IFile) {
                IFile file = (IFile)element;
                if (file.getValue().contains("://")) continue;
                paths.add(file.getValue());
                continue;
            }
            if (!(element instanceof ISubmodelElementCollection)) continue;
            ISubmodelElementCollection collection = (ISubmodelElementCollection)element;
            paths.addAll(this.parseElements(collection.getSubmodelElements().values()));
        }
        return paths;
    }

    public void unzipRelatedFiles() throws IOException, ParserConfigurationException, SAXException, URISyntaxException, InvalidFormatException {
        this.unzipRelatedFiles(this.getRootFolder());
    }

    public void unzipRelatedFiles(Path pathToDirectory) throws InvalidFormatException, IOException, ParserConfigurationException, SAXException, URISyntaxException {
        this.loadAASX();
        List<String> files = this.parseReferencedFilePathsFromAASX();
        for (String filePath : files) {
            this.unzipFile(filePath, this.aasxRoot, pathToDirectory);
        }
        this.closeOPCPackage();
    }

    protected Path getRootFolder() throws IOException, URISyntaxException {
        URI uri = AASXToMetamodelConverter.class.getProtectionDomain().getCodeSource().getLocation().toURI();
        URI parent = new File(uri).getParentFile().toURI();
        return Paths.get(parent);
    }

    private void unzipFile(String filePath, OPCPackage aasxRoot, Path pathToDirectory) throws IOException, URISyntaxException, InvalidFormatException {
        if (filePath.startsWith("/")) {
            filePath = filePath.substring(1);
        }
        if (filePath.isEmpty()) {
            logger.warn("A file with empty path can not be unzipped.");
            return;
        }
        logger.info("Unzipping " + filePath);
        String relativePath = "files/" + VABPathTools.getParentPath(filePath);
        Path destDir = pathToDirectory.resolve(relativePath);
        logger.info("Unzipping to " + destDir);
        Files.createDirectories(destDir, new FileAttribute[0]);
        PackagePart part = aasxRoot.getPart(PackagingURIHelper.createPartName((String)("/" + filePath)));
        if (part == null) {
            logger.warn("File '" + filePath + "' could not be unzipped. It does not exist in .aasx.");
            return;
        }
        String targetPath = destDir.toString() + "/" + VABPathTools.getLastElement(filePath);
        InputStream stream = part.getInputStream();
        FileUtils.copyInputStreamToFile((InputStream)stream, (File)new File(targetPath));
    }
}

