/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.factory.xml.api.parts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.basyx.aas.metamodel.api.parts.IView;
import org.eclipse.basyx.aas.metamodel.map.parts.View;
import org.eclipse.basyx.submodel.factory.xml.XMLHelper;
import org.eclipse.basyx.submodel.factory.xml.converters.qualifier.HasDataSpecificationXMLConverter;
import org.eclipse.basyx.submodel.factory.xml.converters.qualifier.HasSemanticsXMLConverter;
import org.eclipse.basyx.submodel.factory.xml.converters.qualifier.ReferableXMLConverter;
import org.eclipse.basyx.submodel.factory.xml.converters.reference.ReferenceXMLConverter;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.HasDataSpecification;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.HasSemantics;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.Referable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ViewXMLConverter {
    public static final String VIEWS = "aas:views";
    public static final String VIEW = "aas:view";
    public static final String CONTAINED_ELEMENTS = "aas:containedElements";
    public static final String CONTAINED_ELEMENT_REF = "aas:containedElementRef";

    public static Collection<IView> parseViews(Map<String, Object> xmlObject) {
        HashSet<IView> viewSet = new HashSet<IView>();
        if (xmlObject == null) {
            return viewSet;
        }
        if ((xmlObject = (Map)xmlObject.get(VIEWS)) == null) {
            return viewSet;
        }
        List<Map<String, Object>> xmlViewList = XMLHelper.getList(xmlObject.get(VIEW));
        for (Map<String, Object> xmlView : xmlViewList) {
            View view = new View();
            ReferableXMLConverter.populateReferable(xmlView, Referable.createAsFacadeNonStrict(view, KeyElements.VIEW));
            HasSemanticsXMLConverter.populateHasSemantics(xmlView, HasSemantics.createAsFacade(view));
            HasDataSpecificationXMLConverter.populateHasDataSpecification(xmlView, HasDataSpecification.createAsFacade(view));
            Map xmlContainedElementsObject = (Map)xmlView.get(CONTAINED_ELEMENTS);
            Map xmlContainedElementObject = (Map)xmlContainedElementsObject.get(CONTAINED_ELEMENT_REF);
            HashSet<IReference> referenceSet = new HashSet<IReference>();
            referenceSet.add(ReferenceXMLConverter.parseReference(xmlContainedElementObject));
            view.setContainedElement(referenceSet);
            viewSet.add(view);
        }
        return viewSet;
    }

    public static Element buildViewsXML(Document document, Collection<IView> views) {
        Element root = document.createElement(VIEWS);
        ArrayList<Element> viewList = new ArrayList<Element>();
        for (IView view : views) {
            Element viewRoot = document.createElement(VIEW);
            ReferableXMLConverter.populateReferableXML(document, viewRoot, view);
            HasSemanticsXMLConverter.populateHasSemanticsXML(document, viewRoot, view);
            HasDataSpecificationXMLConverter.populateHasDataSpecificationXML(document, viewRoot, view);
            ViewXMLConverter.buildContainedElements(document, viewRoot, view);
            viewList.add(viewRoot);
        }
        for (Element element : viewList) {
            root.appendChild(element);
        }
        return root;
    }

    private static void buildContainedElements(Document document, Element xmlView, IView view) {
        Collection<IReference> containedElement = view.getContainedElement();
        if (containedElement != null) {
            Element xmlContainedElements = document.createElement(CONTAINED_ELEMENTS);
            Element xmlContainedElementsRef = document.createElement(CONTAINED_ELEMENT_REF);
            xmlContainedElements.appendChild(xmlContainedElementsRef);
            xmlContainedElementsRef.appendChild(ReferenceXMLConverter.buildReferencesXML(document, containedElement));
            xmlView.appendChild(xmlContainedElements);
        }
    }
}

