/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.aas.aggregator.mqtt;

import org.eclipse.basyx.aas.aggregator.observing.IAASAggregatorObserver;
import org.eclipse.basyx.extensions.aas.aggregator.mqtt.MqttAASAggregatorHelper;
import org.eclipse.basyx.extensions.shared.mqtt.MqttEventService;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttAASAggregatorObserver
extends MqttEventService
implements IAASAggregatorObserver {
    private static Logger logger = LoggerFactory.getLogger(MqttAASAggregatorObserver.class);

    public MqttAASAggregatorObserver(String serverEndpoint, String clientId) throws MqttException {
        super(serverEndpoint, clientId);
        logger.info("Create new MQTT AAS Aggregator Observer for endpoint " + serverEndpoint);
    }

    public MqttAASAggregatorObserver(String serverEndpoint, String clientId, String user, char[] pw) throws MqttException {
        super(serverEndpoint, clientId, user, pw);
        logger.info("Create new MQTT AAS Aggregator Observer for endpoint " + serverEndpoint);
    }

    public MqttAASAggregatorObserver(MqttClient client) throws MqttException {
        super(client);
        logger.info("Create new MQTT AAS Aggregator Observer for endpoint " + client.getServerURI());
    }

    public MqttAASAggregatorObserver(String serverEndpoint, String clientId, MqttClientPersistence persistence) throws MqttException {
        super(serverEndpoint, clientId, persistence);
        logger.info("Create new MQTT AAS Aggregator Observer for endpoint " + serverEndpoint);
    }

    public MqttAASAggregatorObserver(String serverEndpoint, String clientId, String user, char[] pw, MqttClientPersistence persistence) throws MqttException {
        super(serverEndpoint, clientId, user, pw, persistence);
        logger.info("Create new MQTT AAS Aggregator Observer for endpoint " + serverEndpoint);
    }

    @Override
    public void aasCreated(String shellId) {
        this.sendMqttMessage("BaSyxAggregator_createdAAS", MqttAASAggregatorHelper.createAASChangedPayload(shellId));
    }

    @Override
    public void aasUpdated(String shellId) {
        this.sendMqttMessage("BaSyxAggregator_updatedAAS", MqttAASAggregatorHelper.createAASChangedPayload(shellId));
    }

    @Override
    public void aasDeleted(String shellId) {
        this.sendMqttMessage("BaSyxAggregator_deletedAAS", MqttAASAggregatorHelper.createAASChangedPayload(shellId));
    }
}

