/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.factory.xml.converters.qualifier;

import com.google.common.base.Strings;
import java.util.Map;
import org.eclipse.basyx.submodel.factory.xml.XMLHelper;
import org.eclipse.basyx.submodel.factory.xml.converters.qualifier.LangStringsXMLConverter;
import org.eclipse.basyx.submodel.factory.xml.converters.reference.ReferenceXMLConverter;
import org.eclipse.basyx.submodel.metamodel.api.qualifier.IReferable;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.AdministrativeInformation;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.LangStrings;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.Referable;
import org.eclipse.basyx.submodel.metamodel.map.reference.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ReferableXMLConverter {
    private static final Logger logger = LoggerFactory.getLogger(AdministrativeInformation.class);
    public static final String ID_SHORT = "aas:idShort";
    public static final String CATEGORY = "aas:category";
    public static final String PARENT = "aas:parent";
    public static final String DESCRIPTION = "aas:description";

    public static void populateReferable(Map<String, Object> xmlObject, Referable referable) {
        String idShort = XMLHelper.getString(xmlObject.get(ID_SHORT));
        String category = XMLHelper.getString(xmlObject.get(CATEGORY));
        LangStrings description = ReferableXMLConverter.parseDescription(xmlObject);
        Reference parent = ReferenceXMLConverter.parseReference((Map)xmlObject.get(PARENT));
        if (Strings.isNullOrEmpty((String)idShort)) {
            logger.warn("Invalid XML of Referable. No valid idShort is present. " + xmlObject.toString());
        }
        referable.setIdShort(idShort);
        if (!Strings.isNullOrEmpty((String)category)) {
            referable.setCategory(category);
        }
        if (description != null) {
            referable.setDescription(description);
        }
        if (parent != null) {
            referable.setParent(parent);
        }
    }

    private static LangStrings parseDescription(Map<String, Object> xmlObject) {
        Object descObj = xmlObject.get(DESCRIPTION);
        if (descObj == null) {
            return null;
        }
        return LangStringsXMLConverter.parseLangStrings(descObj, "aas:langString");
    }

    public static void populateReferableXML(Document document, Element root, IReferable referable) {
        if (referable.getIdShort() != null) {
            Element idShortElem = document.createElement(ID_SHORT);
            idShortElem.appendChild(document.createTextNode(referable.getIdShort()));
            root.appendChild(idShortElem);
        }
        if (referable.getCategory() != null) {
            Element categoryElem = document.createElement(CATEGORY);
            categoryElem.appendChild(document.createTextNode(referable.getCategory()));
            root.appendChild(categoryElem);
        }
        if (referable.getDescription() != null && !referable.getDescription().isEmpty()) {
            Element descriptionRoot = document.createElement(DESCRIPTION);
            LangStringsXMLConverter.buildLangStringsXML(document, descriptionRoot, referable.getDescription());
            root.appendChild(descriptionRoot);
        }
        if (referable.getParent() != null) {
            Element xmlParent = ReferenceXMLConverter.buildReferenceXML(document, referable.getParent());
            Element parentElem = document.createElement(PARENT);
            parentElem.appendChild(xmlParent);
            root.appendChild(parentElem);
        }
    }
}

