/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.metamodel.connected.submodelelement.operation;

import java.util.Map;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.operation.IAsyncInvocation;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.OperationExecutionErrorException;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.OperationExecutionTimeoutException;
import org.eclipse.basyx.submodel.restapi.operation.CallbackResponse;
import org.eclipse.basyx.submodel.restapi.operation.ExecutionState;
import org.eclipse.basyx.submodel.restapi.operation.InvocationRequest;
import org.eclipse.basyx.submodel.restapi.operation.InvocationResponse;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.modelprovider.VABElementProxy;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;

public class ConnectedAsyncInvocation
implements IAsyncInvocation {
    private String operationId;
    private String requestId;
    private VABElementProxy proxy;
    private Object result = null;
    private boolean resultRetrieved = false;

    public ConnectedAsyncInvocation(VABElementProxy proxy, String operationId, InvocationRequest request) {
        this.proxy = proxy;
        this.operationId = operationId;
        CallbackResponse response = CallbackResponse.createAsFacade((Map)proxy.invokeOperation("invoke?async=true", request));
        this.requestId = response.getRequestId();
    }

    @Override
    public Object getResult() {
        while (!this.isFinished()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.result instanceof Exception) {
            throw new OperationExecutionErrorException("Exception while executing Invocation '" + this.requestId + "' of Operation '" + this.operationId + "'");
        }
        if (ExecutionState.FAILED == this.result) {
            throw new OperationExecutionErrorException("Exception while executing Invocation '" + this.requestId + "' of Operation '" + this.operationId + "'; Operation failed");
        }
        if (ExecutionState.TIMEOUT == this.result) {
            throw new OperationExecutionTimeoutException("Invocation '" + this.requestId + "' of Operation '" + this.operationId + "' timed out");
        }
        return this.result;
    }

    @Override
    public boolean isFinished() {
        if (this.resultRetrieved) {
            return true;
        }
        this.retrieveResultDirectly();
        return this.resultRetrieved;
    }

    private void retrieveResultDirectly() {
        Object responseObj = null;
        try {
            responseObj = this.proxy.getValue(this.getListPath());
        }
        catch (ProviderException e) {
            if (e.getCause() instanceof RuntimeException) {
                this.resultRetrieved = true;
                this.result = e;
            }
            throw e;
        }
        InvocationResponse response = null;
        if (responseObj instanceof InvocationResponse) {
            response = (InvocationResponse)responseObj;
        } else if (responseObj instanceof Map) {
            response = InvocationResponse.createAsFacade((Map)responseObj);
        } else {
            throw new ProviderException("Response for requestId " + this.requestId + " invalid!");
        }
        switch (response.getExecutionState()) {
            case COMPLETED: {
                this.resultRetrieved = true;
                this.result = response.getFirstOutput();
                break;
            }
            case FAILED: 
            case TIMEOUT: {
                this.resultRetrieved = true;
                this.result = response.getExecutionState();
                break;
            }
        }
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getOperationId() {
        return this.operationId;
    }

    private String getListPath() {
        return VABPathTools.concatenatePaths("invocationList", this.requestId);
    }
}

