/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.metamodel.facade;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.basyx.submodel.metamodel.api.IElementContainer;
import org.eclipse.basyx.submodel.metamodel.api.reference.IKey;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.LangStrings;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.entity.EntityValue;

public class ElementContainerValuesHelper {
    public static Map<String, Object> getSubmodelValue(IElementContainer container) {
        Map<String, ISubmodelElement> elements = container.getSubmodelElements();
        return (Map)ElementContainerValuesHelper.handleValue(elements.values());
    }

    private static Object handleValue(Object value) {
        if (value instanceof Collection && !(value instanceof LangStrings)) {
            return ElementContainerValuesHelper.handleValueCollection((Collection)value);
        }
        if (value instanceof EntityValue) {
            return ElementContainerValuesHelper.handleEntityValue((EntityValue)value);
        }
        return value;
    }

    private static Object handleEntityValue(EntityValue value) {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        if (value.getAsset() != null) {
            ret.put("asset", ElementContainerValuesHelper.handleReference(value.getAsset()));
        }
        ret.put("statements", ElementContainerValuesHelper.handleValueCollection(value.getStatement()));
        return ret;
    }

    private static Object handleReference(IReference asset) {
        LinkedHashMap<String, List<IKey>> ret = new LinkedHashMap<String, List<IKey>>();
        ret.put("keys", asset.getKeys());
        return ret;
    }

    private static Map<String, Object> handleValueCollection(Collection<ISubmodelElement> collection) {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        for (ISubmodelElement element : collection) {
            try {
                ret.put(element.getIdShort(), ElementContainerValuesHelper.handleValue(element.getValue()));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
        return ret;
    }
}

