/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.metamodel.map.qualifier.qualifiable;

import java.util.Map;
import org.eclipse.basyx.aas.metamodel.exception.MetamodelConstructionException;
import org.eclipse.basyx.submodel.metamodel.api.qualifier.qualifiable.IQualifier;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.map.modeltype.ModelType;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.HasSemantics;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.qualifiable.Constraint;
import org.eclipse.basyx.submodel.metamodel.map.reference.Reference;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.valuetype.ValueType;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.valuetype.ValueTypeHelper;

public class Qualifier
extends Constraint
implements IQualifier {
    public static final String QUALIFIER = "qualifier";
    public static final String TYPE = "type";
    public static final String VALUE = "value";
    public static final String VALUEID = "valueId";
    public static final String VALUETYPE = "valueType";
    public static final String MODELTYPE = "Qualifier";

    public Qualifier() {
        this.putAll(new ModelType(MODELTYPE));
    }

    @Deprecated
    public Qualifier(String type, String valueType) {
        this(type, null, ValueType.fromString(valueType), null);
    }

    @Deprecated
    public Qualifier(String type, String value, String valueType, Reference valueId) {
        this(type, value, ValueType.fromString(valueType), valueId);
    }

    public Qualifier(String type, String value, ValueType valueType, Reference valueId) {
        this();
        this.setValueType(valueType);
        this.setType(type);
        this.setValue(value);
        this.setValueId(valueId);
    }

    public Qualifier(String type, ValueType valueType) {
        this(type, null, valueType, null);
    }

    public static Qualifier createAsFacade(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        if (!Qualifier.isValid(map)) {
            throw new MetamodelConstructionException(Qualifier.class, map);
        }
        Qualifier ret = new Qualifier();
        ret.setMap(map);
        return ret;
    }

    public static boolean isValid(Map<String, Object> map) {
        return map != null && map.containsKey(TYPE) && map.containsKey(VALUETYPE);
    }

    public void setType(String obj) {
        this.put(TYPE, obj);
    }

    @Override
    public String getType() {
        return (String)this.get(TYPE);
    }

    public void setValue(Object obj) {
        this.put(VALUE, ValueTypeHelper.prepareForSerialization(obj));
        if (this.getValueType() == null) {
            this.put(VALUETYPE, ValueTypeHelper.getType(obj).toString());
        }
    }

    @Override
    public Object getValue() {
        Object value = this.get(VALUE);
        if (value instanceof String) {
            return ValueTypeHelper.getJavaObject(value, this.getValueType());
        }
        return value;
    }

    public void setValueId(IReference obj) {
        this.put(VALUEID, obj);
    }

    @Override
    public IReference getValueId() {
        return Reference.createAsFacade((Map)this.get(VALUEID));
    }

    public void setValueType(ValueType obj) {
        this.put(VALUETYPE, obj.toString());
    }

    @Override
    public ValueType getValueType() {
        return ValueTypeHelper.readTypeDef(this.get(VALUETYPE));
    }

    @Override
    public IReference getSemanticId() {
        return HasSemantics.createAsFacade(this).getSemanticId();
    }

    public void setSemanticId(IReference ref) {
        HasSemantics.createAsFacade(this).setSemanticId(ref);
    }
}

