/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.valuetype;

import java.math.BigInteger;
import java.time.Duration;
import java.time.Period;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.valuetype.ValueType;

public class ValueTypeHelper {
    private static Map<String, ValueType> typeMap = new LinkedHashMap<String, ValueType>();
    private static final String TYPE_NAME = "name";
    private static final String TYPE_OBJECT = "dataObjectType";

    public static ValueType fromName(String name) {
        if (typeMap.containsKey(name)) {
            return typeMap.get(name);
        }
        throw new RuntimeException("Unknown type name " + name + "; can not handle this PropertyValueType");
    }

    public static ValueType getType(Object obj) {
        ValueType objectType;
        if (obj == null) {
            objectType = ValueType.None;
        } else {
            Class<?> c = obj.getClass();
            if (c == Byte.TYPE || c == Byte.class) {
                objectType = ValueType.Int8;
            } else if (c == Short.TYPE || c == Short.class) {
                objectType = ValueType.Int16;
            } else if (c == Integer.TYPE || c == Integer.class) {
                objectType = ValueType.Int32;
            } else if (c == Long.TYPE || c == Long.class) {
                objectType = ValueType.Int64;
            } else if (c == BigInteger.class) {
                BigInteger tmp = (BigInteger)obj;
                objectType = tmp.compareTo(new BigInteger("0")) > 0 ? ValueType.PositiveInteger : (tmp.compareTo(new BigInteger("0")) < 0 ? ValueType.NegativeInteger : ValueType.Integer);
            } else if (c == Void.TYPE || c == Void.class) {
                objectType = ValueType.None;
            } else if (c == Boolean.TYPE || c == Boolean.class) {
                objectType = ValueType.Boolean;
            } else if (c == Float.TYPE || c == Float.class) {
                objectType = ValueType.Float;
            } else if (c == Double.TYPE || c == Double.class) {
                objectType = ValueType.Double;
            } else if (c == String.class) {
                objectType = ValueType.String;
            } else if (c == Duration.class) {
                objectType = ValueType.Duration;
            } else if (c == Period.class) {
                objectType = ValueType.YearMonthDuration;
            } else if (c == QName.class) {
                objectType = ValueType.QName;
            } else if (obj instanceof XMLGregorianCalendar) {
                objectType = ValueType.DateTime;
            } else {
                throw new RuntimeException("Cannot map object " + obj + " to any PropertyValueTypeDef");
            }
        }
        return objectType;
    }

    public static Object getJavaObject(Object value, ValueType objType) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof String)) {
            value = value.toString();
        }
        Object target = null;
        if (objType != null) {
            switch (objType) {
                case Int8: {
                    if (((String)value).isEmpty()) {
                        target = new Byte("NaN");
                        break;
                    }
                    target = new Byte((String)value);
                    break;
                }
                case Int16: 
                case UInt8: {
                    if (((String)value).isEmpty()) {
                        target = new Short("NaN");
                        break;
                    }
                    target = new Short((String)value);
                    break;
                }
                case Int32: 
                case UInt16: {
                    if (((String)value).isEmpty()) {
                        target = new Integer("NaN");
                        break;
                    }
                    target = new Integer((String)value);
                    break;
                }
                case Int64: 
                case UInt32: {
                    if (((String)value).isEmpty()) {
                        target = new Long("NaN");
                        break;
                    }
                    target = new Long((String)value);
                    break;
                }
                case UInt64: 
                case Integer: 
                case PositiveInteger: 
                case NonPositiveInteger: 
                case NonNegativeInteger: 
                case NegativeInteger: {
                    if (((String)value).isEmpty()) {
                        target = new BigInteger("NaN");
                        break;
                    }
                    target = new BigInteger((String)value);
                    break;
                }
                case Double: {
                    if (((String)value).isEmpty()) {
                        target = new Double("NaN");
                        break;
                    }
                    target = new Double((String)value);
                    break;
                }
                case Float: {
                    if (((String)value).isEmpty()) {
                        target = new Float("NaN");
                        break;
                    }
                    target = new Float((String)value);
                    break;
                }
                case Boolean: {
                    target = new Boolean((String)value);
                    break;
                }
                case AnySimpleType: 
                case String: 
                case LangString: 
                case AnyURI: 
                case Base64Binary: 
                case HexBinary: 
                case NOTATION: 
                case ENTITY: 
                case ID: 
                case IDREF: {
                    target = value;
                    break;
                }
                case Duration: 
                case DayTimeDuration: {
                    target = Duration.parse((String)value);
                    break;
                }
                case YearMonthDuration: {
                    target = Period.parse((String)value);
                    break;
                }
                case DateTime: 
                case DateTimeStamp: 
                case GDay: 
                case GMonth: 
                case GMonthDay: 
                case GYear: 
                case GYearMonth: {
                    try {
                        target = DatatypeFactory.newInstance().newXMLGregorianCalendar((String)value);
                        break;
                    }
                    catch (DatatypeConfigurationException e) {
                        e.printStackTrace();
                        throw new RuntimeException("Could not create DatatypeFactory for XMLGregorianCaldner handling");
                    }
                }
                case QName: {
                    target = QName.valueOf((String)value);
                    break;
                }
                default: {
                    target = value;
                }
            }
            return target;
        }
        return null;
    }

    public static Object prepareForSerialization(Object value) {
        Class<?> c;
        if (value != null && ((c = value.getClass()) == Duration.class || c == Period.class || c == QName.class || value instanceof XMLGregorianCalendar)) {
            return value.toString();
        }
        return value;
    }

    public static ValueType readTypeDef(Object vTypeMap) {
        if (vTypeMap instanceof String) {
            return ValueTypeHelper.fromName((String)vTypeMap);
        }
        if (vTypeMap instanceof Map) {
            Map map = (Map)vTypeMap;
            Map dot = (Map)map.get(TYPE_OBJECT);
            return ValueTypeHelper.fromName(dot.get(TYPE_NAME).toString());
        }
        return null;
    }

    static {
        for (ValueType t : ValueType.values()) {
            typeMap.put(t.toString(), t);
        }
    }
}

