/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.metamodel.map.submodelelement.relationship;

import java.util.Map;
import org.eclipse.basyx.aas.metamodel.exception.MetamodelConstructionException;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.relationship.IRelationshipElement;
import org.eclipse.basyx.submodel.metamodel.map.modeltype.ModelType;
import org.eclipse.basyx.submodel.metamodel.map.reference.Reference;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElement;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.relationship.RelationshipElementValue;

public class RelationshipElement
extends SubmodelElement
implements IRelationshipElement {
    public static final String FIRST = "first";
    public static final String SECOND = "second";
    public static final String MODELTYPE = "RelationshipElement";

    public RelationshipElement() {
        this.putAll(new ModelType(MODELTYPE));
    }

    public RelationshipElement(IReference first, IReference second) {
        this.putAll(new ModelType(MODELTYPE));
        this.put(FIRST, first);
        this.put(SECOND, second);
    }

    public RelationshipElement(String idShort, IReference first, IReference second) {
        this(first, second);
        this.setIdShort(idShort);
    }

    public static RelationshipElement createAsFacade(Map<String, Object> obj) {
        if (obj == null) {
            return null;
        }
        if (!RelationshipElement.isValid(obj)) {
            throw new MetamodelConstructionException(RelationshipElement.class, obj);
        }
        RelationshipElement ret = new RelationshipElement();
        ret.setMap(obj);
        return ret;
    }

    public static boolean isValid(Map<String, Object> obj) {
        return SubmodelElement.isValid(obj) && obj.containsKey(FIRST) && obj.containsKey(SECOND) && Reference.isValid((Map)obj.get(FIRST)) && Reference.isValid((Map)obj.get(SECOND));
    }

    public static boolean isRelationshipElement(Map<String, Object> map) {
        String modelType = ModelType.createAsFacade(map).getName();
        return MODELTYPE.equals(modelType) || modelType == null && map.containsKey(FIRST) && map.containsKey(SECOND);
    }

    public void setFirst(IReference first) {
        this.put(FIRST, first);
    }

    public IReference getFirst() {
        return Reference.createAsFacade((Map)this.get(FIRST));
    }

    public void setSecond(IReference second) {
        this.put(SECOND, second);
    }

    public IReference getSecond() {
        return Reference.createAsFacade((Map)this.get(SECOND));
    }

    @Override
    protected KeyElements getKeyElement() {
        return KeyElements.RELATIONSHIPELEMENT;
    }

    @Override
    public RelationshipElementValue getValue() {
        return new RelationshipElementValue(this.getFirst(), this.getSecond());
    }

    @Override
    public void setValue(Object value) {
        if (!RelationshipElementValue.isRelationshipElementValue(value)) {
            throw new IllegalArgumentException("Given Object is not an RelationshipElementValue");
        }
        RelationshipElementValue rev = RelationshipElementValue.createAsFacade((Map)value);
        this.setValue(rev);
    }

    @Override
    public RelationshipElement getLocalCopy() {
        RelationshipElement copy = new RelationshipElement();
        copy.putAll(this);
        return copy;
    }

    @Override
    public void setValue(RelationshipElementValue value) {
        this.setFirst(value.getFirst());
        this.setSecond(value.getSecond());
    }
}

