/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.restapi.observing;

import java.util.Collection;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.operation.IOperation;
import org.eclipse.basyx.submodel.observer.Observable;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPI;
import org.eclipse.basyx.submodel.restapi.observing.ISubmodelAPIObserver;

public class ObservableSubmodelAPI
extends Observable<ISubmodelAPIObserver>
implements ISubmodelAPI {
    ISubmodelAPI submodelAPI;

    public ObservableSubmodelAPI(ISubmodelAPI observerdAPI) {
        this.submodelAPI = observerdAPI;
    }

    @Override
    public ISubmodel getSubmodel() {
        return this.submodelAPI.getSubmodel();
    }

    @Override
    public void addSubmodelElement(ISubmodelElement elem) {
        this.submodelAPI.addSubmodelElement(elem);
        this.observers.stream().forEach(o -> o.elementAdded(elem.getIdShort(), elem.getValue()));
    }

    @Override
    public void addSubmodelElement(String idShortPath, ISubmodelElement elem) {
        this.submodelAPI.addSubmodelElement(idShortPath, elem);
        this.observers.stream().forEach(o -> o.elementAdded(idShortPath, elem.getValue()));
    }

    @Override
    public ISubmodelElement getSubmodelElement(String idShortPath) {
        return this.submodelAPI.getSubmodelElement(idShortPath);
    }

    @Override
    public void deleteSubmodelElement(String idShortPath) {
        this.submodelAPI.deleteSubmodelElement(idShortPath);
        this.observers.stream().forEach(o -> o.elementDeleted(idShortPath));
    }

    @Override
    public Collection<IOperation> getOperations() {
        return this.submodelAPI.getOperations();
    }

    @Override
    public Collection<ISubmodelElement> getSubmodelElements() {
        return this.submodelAPI.getSubmodelElements();
    }

    @Override
    public void updateSubmodelElement(String idShortPath, Object newValue) {
        this.submodelAPI.updateSubmodelElement(idShortPath, newValue);
        this.observers.stream().forEach(o -> o.elementUpdated(idShortPath, newValue));
    }

    @Override
    public Object getSubmodelElementValue(String idShortPath) {
        return this.submodelAPI.getSubmodelElementValue(idShortPath);
    }

    @Override
    public Object invokeOperation(String idShortPath, Object ... params) {
        return this.submodelAPI.invokeOperation(idShortPath, params);
    }

    @Override
    public Object invokeAsync(String idShortPath, Object ... params) {
        return this.submodelAPI.invokeAsync(idShortPath, params);
    }

    @Override
    public Object getOperationResult(String idShort, String requestId) {
        return this.submodelAPI.getOperationResult(idShort, requestId);
    }
}

