/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.types.digitalnameplate.submodelelementcollections.address;

import java.util.Map;
import org.eclipse.basyx.aas.metamodel.exception.MetamodelConstructionException;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IdentifierType;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyType;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IMultiLanguageProperty;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IProperty;
import org.eclipse.basyx.submodel.metamodel.facade.SubmodelElementMapCollectionConverter;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.LangString;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.LangStrings;
import org.eclipse.basyx.submodel.metamodel.map.reference.Key;
import org.eclipse.basyx.submodel.metamodel.map.reference.Reference;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElementCollection;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.MultiLanguageProperty;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.Property;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.valuetype.ValueType;
import org.eclipse.basyx.submodel.types.digitalnameplate.enums.FaxType;

public class Fax
extends SubmodelElementCollection {
    public static final String FAXNUMBERID = "FaxNumber";
    public static final String TYPEOFFAXID = "TypeOfFaxNumber";
    public static final Reference SEMANTICID = new Reference(new Key(KeyElements.CONCEPTDESCRIPTION, false, "0173-1#02-AAQ834#005", KeyType.IRDI));

    private Fax() {
    }

    public Fax(String idShort, LangString faxNumber) {
        super(idShort);
        this.setSemanticId(SEMANTICID);
        this.setFaxNumber(faxNumber);
    }

    public Fax(String idShort, MultiLanguageProperty faxNumber) {
        super(idShort);
        this.setSemanticId(SEMANTICID);
        this.setFaxNumber(faxNumber);
    }

    public static Fax createAsFacade(Map<String, Object> obj) {
        if (obj == null) {
            return null;
        }
        if (!Fax.isValid(obj)) {
            throw new MetamodelConstructionException(Fax.class, obj);
        }
        Fax fax = new Fax();
        fax.setMap(SubmodelElementMapCollectionConverter.mapToSmECollection(obj));
        return fax;
    }

    private static Fax createAsFacadeNonStrict(Map<String, Object> obj) {
        if (obj == null) {
            return null;
        }
        Fax fax = new Fax();
        fax.setMap(SubmodelElementMapCollectionConverter.mapToSmECollection(obj));
        return fax;
    }

    public static boolean isValid(Map<String, Object> obj) {
        Fax fax = Fax.createAsFacadeNonStrict(obj);
        return SubmodelElementCollection.isValid(obj) && MultiLanguageProperty.isValid((Map)((Object)fax.getFaxNumber()));
    }

    public void setFaxNumber(MultiLanguageProperty faxNumber) {
        this.addSubmodelElement(faxNumber);
    }

    public void setFaxNumber(LangString faxNumber) {
        MultiLanguageProperty faxProp = new MultiLanguageProperty(FAXNUMBERID);
        faxProp.setSemanticId(new Reference(new Key(KeyElements.CONCEPTDESCRIPTION, false, "0173-1#02-AAO195#002", IdentifierType.IRDI)));
        faxProp.setValue(new LangStrings(faxNumber));
        this.setFaxNumber(faxProp);
    }

    public void setTypeOfFaxNumber(Property type) {
        this.addSubmodelElement(type);
    }

    public void setTypeOfFaxNumber(FaxType type) {
        Property faxTypeProp = new Property(TYPEOFFAXID, ValueType.String);
        faxTypeProp.setSemanticId(new Reference(new Key(KeyElements.CONCEPTDESCRIPTION, false, "0173-1#02-AAO196#003", IdentifierType.IRDI)));
        faxTypeProp.setValue(type.toString());
        this.setTypeOfFaxNumber(faxTypeProp);
    }

    public IProperty getTypeOfFaxNumber() {
        return Property.createAsFacade((Map)((Object)this.getSubmodelElement(TYPEOFFAXID)));
    }

    public IMultiLanguageProperty getFaxNumber() {
        return MultiLanguageProperty.createAsFacade((Map)((Object)this.getSubmodelElement(FAXNUMBERID)));
    }
}

