/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.vab.protocol.opcua.connector;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.basyx.vab.protocol.opcua.connector.ClientConfiguration;
import org.eclipse.basyx.vab.protocol.opcua.connector.milo.MiloOpcUaClient;
import org.eclipse.basyx.vab.protocol.opcua.exception.OpcUaException;
import org.eclipse.basyx.vab.protocol.opcua.types.NodeId;

public interface IOpcUaClient {
    public static IOpcUaClient create(String endpointUrl) {
        return new MiloOpcUaClient(endpointUrl);
    }

    public ClientConfiguration getConfiguration();

    public void setConfiguration(ClientConfiguration var1);

    public String getEndpointUrl();

    public boolean hasConnected();

    public NodeId translateBrowsePathToNodeId(NodeId var1, String var2);

    public NodeId translateBrowsePathToNodeId(String var1);

    public CompletableFuture<NodeId> translateBrowsePathToNodeIdAsync(NodeId var1, String var2);

    public CompletableFuture<NodeId> translateBrowsePathToNodeIdAsync(String var1);

    public List<NodeId> translateBrowsePathToParentAndTargetNodeId(String var1);

    public CompletableFuture<List<NodeId>> translateBrowsePathToParentAndTargetNodeIdAsync(String var1);

    public List<Object> invokeMethod(NodeId var1, NodeId var2, Object ... var3) throws OpcUaException;

    public CompletableFuture<List<Object>> invokeMethodAsync(NodeId var1, NodeId var2, Object ... var3);

    public Object readValue(NodeId var1) throws OpcUaException;

    public CompletableFuture<Object> readValueAsync(NodeId var1);

    public void writeValue(NodeId var1, Object var2) throws OpcUaException;

    public CompletableFuture<Void> writeValueAsync(NodeId var1, Object var2);
}

