/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.vab.protocol.opcua.connector.milo;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.eclipse.basyx.vab.protocol.opcua.connector.ClientConfiguration;
import org.eclipse.basyx.vab.protocol.opcua.connector.IOpcUaClient;
import org.eclipse.basyx.vab.protocol.opcua.connector.milo.BrowsePathHelper;
import org.eclipse.basyx.vab.protocol.opcua.exception.AmbiguousBrowsePathException;
import org.eclipse.basyx.vab.protocol.opcua.exception.OpcUaException;
import org.eclipse.basyx.vab.protocol.opcua.types.NodeId;
import org.eclipse.basyx.vab.protocol.opcua.types.SecurityPolicy;
import org.eclipse.basyx.vab.protocol.opcua.types.UnsignedByte;
import org.eclipse.basyx.vab.protocol.opcua.types.UnsignedInteger;
import org.eclipse.basyx.vab.protocol.opcua.types.UnsignedLong;
import org.eclipse.basyx.vab.protocol.opcua.types.UnsignedShort;
import org.eclipse.milo.opcua.sdk.client.AddressSpace;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.api.UaClient;
import org.eclipse.milo.opcua.sdk.client.api.config.OpcUaClientConfig;
import org.eclipse.milo.opcua.sdk.client.api.config.OpcUaClientConfigBuilder;
import org.eclipse.milo.opcua.sdk.client.api.identity.AnonymousProvider;
import org.eclipse.milo.opcua.sdk.client.api.identity.IdentityProvider;
import org.eclipse.milo.opcua.stack.client.DiscoveryClient;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowsePath;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowsePathResult;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowsePathTarget;
import org.eclipse.milo.opcua.stack.core.types.structured.CallMethodRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.TranslateBrowsePathsToNodeIdsResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiloOpcUaClient
implements IOpcUaClient {
    private static final Logger logger = LoggerFactory.getLogger(MiloOpcUaClient.class);
    private static DatatypeFactory xmlDatatypeFactory;
    private ClientConfiguration configuration = new ClientConfiguration();
    private OpcUaClientConfigBuilder miloConfiguration;
    private CompletableFuture<UaClient> futureClient;
    private String endpointUrl;

    public MiloOpcUaClient(String endpointUrl) {
        if (endpointUrl == null || endpointUrl.isEmpty()) {
            throw new IllegalArgumentException("endpointUrl must not be null.");
        }
        this.endpointUrl = endpointUrl;
    }

    @Override
    public synchronized ClientConfiguration getConfiguration() {
        return this.configuration.clone();
    }

    @Override
    public synchronized void setConfiguration(ClientConfiguration configuration) {
        if (this.hasConnected()) {
            throw new IllegalStateException("Cannot change security configuration after opening the connection.");
        }
        this.configuration = configuration != null ? configuration.clone() : new ClientConfiguration();
    }

    public synchronized void setConfiguration(OpcUaClientConfigBuilder configuration) {
        if (this.hasConnected()) {
            throw new IllegalStateException("Cannot change security configuration after opening the connection.");
        }
        this.miloConfiguration = configuration;
    }

    @Override
    public String getEndpointUrl() {
        return this.endpointUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasConnected() {
        MiloOpcUaClient miloOpcUaClient = this;
        synchronized (miloOpcUaClient) {
            return this.futureClient != null;
        }
    }

    public synchronized CompletableFuture<UaClient> getClient() {
        if (this.futureClient != null) {
            return this.futureClient;
        }
        OpcUaClient client = this.createClient();
        this.futureClient = client.connect();
        return this.futureClient;
    }

    private OpcUaClient createClient() {
        SecurityPolicy securityPolicy = this.configuration.getSecurityPolicy();
        org.eclipse.basyx.vab.protocol.opcua.types.MessageSecurityMode messageSecurityMode = this.configuration.getMessageSecurityMode();
        Predicate<EndpointDescription> endpointFilter = ep -> {
            boolean securityPolicyMatches = ep.getSecurityPolicyUri().equals(this.mapSecurityPolicy(securityPolicy).getUri());
            boolean messageSecurityModeMatches = ep.getSecurityMode() == this.mapMessageSecurityMode(messageSecurityMode);
            return securityPolicyMatches && messageSecurityModeMatches;
        };
        EndpointDescription endpoint = this.discoverEndpoint(this.endpointUrl, endpointFilter);
        logger.debug("Using endpoint: {} [{}/{}]", new Object[]{endpoint.getEndpointUrl(), securityPolicy, messageSecurityMode});
        try {
            OpcUaClientConfig config = this.buildMiloConfiguration(endpoint);
            return OpcUaClient.create((OpcUaClientConfig)config);
        }
        catch (UaException e) {
            throw new OpcUaException(e);
        }
    }

    private OpcUaClientConfig buildMiloConfiguration(EndpointDescription endpoint) {
        OpcUaClientConfigBuilder builder = this.miloConfiguration != null ? this.miloConfiguration : this.createDefaultMiloConfigBuilder();
        builder.setApplicationName(LocalizedText.english((String)this.configuration.getApplicationName())).setApplicationUri(this.configuration.getApplicationUri()).setCertificate(this.configuration.getCertificate()).setKeyPair(this.configuration.getKeyPair()).setEndpoint(endpoint);
        return builder.build();
    }

    private OpcUaClientConfigBuilder createDefaultMiloConfigBuilder() {
        return OpcUaClientConfig.builder().setIdentityProvider((IdentityProvider)new AnonymousProvider());
    }

    private EndpointDescription discoverEndpoint(String endpointUrl, Predicate<EndpointDescription> filter) throws OpcUaException {
        try {
            return (EndpointDescription)((CompletableFuture)this.discoverEndpoints(endpointUrl).thenApply(list -> (EndpointDescription)list.stream().filter(filter).findFirst().orElseThrow(() -> new OpcUaException("No endpoint found at " + endpointUrl)))).get();
        }
        catch (ExecutionException e) {
            throw (OpcUaException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new OpcUaException("Endpoint discovery interrupted", e);
        }
    }

    private CompletableFuture<List<EndpointDescription>> discoverEndpoints(String endpointUrl) {
        return DiscoveryClient.getEndpoints((String)endpointUrl).handleAsync((list, ex) -> {
            if (ex != null) {
                return this.retryDiscovery(endpointUrl);
            }
            return list;
        });
    }

    private List<EndpointDescription> retryDiscovery(String endpointUrl) {
        String discoveryUrl = this.createExplicitDiscoveryUrl(endpointUrl);
        logger.debug("Discovery failed at original endpoint URL. Trying with explicit discovery URL: {}", (Object)discoveryUrl);
        try {
            return (List)DiscoveryClient.getEndpoints((String)discoveryUrl).get();
        }
        catch (InterruptedException e) {
            logger.error("Endpoint discovery failed because thread was interrupted.");
            Thread.currentThread().interrupt();
            throw new OpcUaException(e);
        }
        catch (ExecutionException e) {
            logger.error("Endpoint discovery failed.");
            throw this.makeOpcUaExceptionFromCause(e);
        }
    }

    private String createExplicitDiscoveryUrl(String discoveryUrl) {
        discoveryUrl = ((String)discoveryUrl).endsWith("/") ? discoveryUrl : (String)discoveryUrl + "/";
        return (String)discoveryUrl + "discovery";
    }

    private org.eclipse.milo.opcua.stack.core.security.SecurityPolicy mapSecurityPolicy(SecurityPolicy securityPolicy) {
        return org.eclipse.milo.opcua.stack.core.security.SecurityPolicy.valueOf((String)securityPolicy.toString());
    }

    private MessageSecurityMode mapMessageSecurityMode(org.eclipse.basyx.vab.protocol.opcua.types.MessageSecurityMode messageSecurityMode) {
        return MessageSecurityMode.valueOf((String)messageSecurityMode.toString());
    }

    @Override
    public NodeId translateBrowsePathToNodeId(String browsePath) {
        try {
            return this.translateBrowsePathToNodeIdAsync(browsePath).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new OpcUaException(e);
        }
        catch (ExecutionException e) {
            throw this.makeOpcUaExceptionFromCause(e);
        }
    }

    @Override
    public CompletableFuture<NodeId> translateBrowsePathToNodeIdAsync(String browsePath) {
        BrowsePath bp = BrowsePathHelper.parse(browsePath);
        return this.translateBrowsePathToNodeId(bp);
    }

    @Override
    public NodeId translateBrowsePathToNodeId(NodeId startingNode, String relativePath) {
        try {
            return this.translateBrowsePathToNodeIdAsync(startingNode, relativePath).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new OpcUaException(e);
        }
        catch (ExecutionException e) {
            throw this.makeOpcUaExceptionFromCause(e);
        }
    }

    @Override
    public CompletableFuture<NodeId> translateBrowsePathToNodeIdAsync(NodeId startingNode, String relativePath) {
        if (!(startingNode instanceof NodeId)) {
            throw new IllegalArgumentException();
        }
        BrowsePath bp = BrowsePathHelper.parse(startingNode, relativePath);
        return this.translateBrowsePathToNodeId(bp);
    }

    @Override
    public List<NodeId> translateBrowsePathToParentAndTargetNodeId(String browsePath) {
        try {
            return this.translateBrowsePathToParentAndTargetNodeIdAsync(browsePath).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new OpcUaException(e);
        }
        catch (ExecutionException e) {
            throw this.makeOpcUaExceptionFromCause(e);
        }
    }

    @Override
    public CompletableFuture<List<NodeId>> translateBrowsePathToParentAndTargetNodeIdAsync(String browsePath) {
        BrowsePath targetPath = BrowsePathHelper.parse(browsePath);
        BrowsePath parentPath = BrowsePathHelper.getParent(targetPath);
        ArrayList<BrowsePath> browsePaths = new ArrayList<BrowsePath>(2);
        browsePaths.add(0, targetPath);
        browsePaths.add(1, parentPath);
        return this.translateBrowsePathsToNodeIds(browsePaths);
    }

    private CompletableFuture<List<NodeId>> translateBrowsePathsToNodeIds(List<BrowsePath> browsePaths) {
        CompletionStage futureAddressSpace = this.getClient().thenApplyAsync(UaClient::getAddressSpace);
        Function<TranslateBrowsePathsToNodeIdsResponse, BrowsePathResult[]> getResults = response -> {
            if (!response.getResponseHeader().getServiceResult().isGood()) {
                throw new OpcUaException("TranslateBrowsePaths failed with status code: " + response.getResponseHeader().getServiceResult());
            }
            return response.getResults();
        };
        Function<BrowsePathResult[], List> extractExpandedNodeIds = results -> {
            ArrayList<ExpandedNodeId> exNodeIds = new ArrayList<ExpandedNodeId>(((BrowsePathResult[])results).length);
            for (int i = 0; i < ((BrowsePathResult[])results).length; ++i) {
                BrowsePathResult r = results[i];
                if (!r.getStatusCode().isGood()) {
                    String exceptionMessage = String.format("Browse path [%s] failed to resolve with status code: %s", browsePaths.get(i), r.getStatusCode());
                    throw new ResourceNotFoundException(exceptionMessage);
                }
                BrowsePathTarget[] targets = r.getTargets();
                if (targets.length > 1) {
                    String exceptionMessage = String.format("Browse path [%s] leads to multiple targets.", browsePaths.get(i));
                    throw new AmbiguousBrowsePathException(exceptionMessage);
                }
                exNodeIds.add(i, targets[0].getTargetId());
            }
            return exNodeIds;
        };
        BiFunction<List, AddressSpace, List> mapToNodeIds = (expandedNodeIds, addressSpace) -> expandedNodeIds.stream().map(arg_0 -> ((AddressSpace)addressSpace).toNodeId(arg_0)).map(NodeId::new).collect(Collectors.toList());
        UnaryOperator log = nodeIds -> {
            List bpStrings = browsePaths.stream().map(bp -> BrowsePathHelper.toString(bp.getRelativePath())).collect(Collectors.toList());
            logger.debug("Translated browse paths {} to node ids {}", bpStrings, nodeIds);
            return nodeIds;
        };
        CompletionStage future = ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.getClient().thenCompose(client -> client.translateBrowsePaths(browsePaths))).thenApply(getResults)).thenApply(extractExpandedNodeIds)).thenCombine(futureAddressSpace, mapToNodeIds);
        return logger.isDebugEnabled() ? ((CompletableFuture)future).thenApply((Function)log) : future;
    }

    private CompletableFuture<NodeId> translateBrowsePathToNodeId(BrowsePath browsePath) {
        List<BrowsePath> browsePaths = Collections.singletonList(browsePath);
        return this.translateBrowsePathsToNodeIds(browsePaths).thenApply(nodeIds -> (NodeId)nodeIds.get(0));
    }

    @Override
    public Object readValue(NodeId nodeId) throws OpcUaException {
        try {
            return this.readValueAsync(nodeId).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new OpcUaException(e);
        }
        catch (ExecutionException e) {
            throw this.makeOpcUaExceptionFromCause(e);
        }
    }

    @Override
    public CompletableFuture<Object> readValueAsync(NodeId nodeId) {
        if (nodeId == null) {
            throw new IllegalArgumentException("nodeId must not be null.");
        }
        logger.debug("Reading node '{}'.", (Object)nodeId);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.getClient().thenCompose(client -> client.readValue(0.0, TimestampsToReturn.Neither, nodeId.getInternalId()))).thenApply(dv -> {
            if (dv.getStatusCode().isGood()) {
                return dv.getValue();
            }
            throw new OpcUaException("Read failed with: " + dv.getStatusCode());
        })).thenApply(this::unwrapVariant)).exceptionally(e -> {
            if (e instanceof CompletionException) {
                throw this.makeOpcUaExceptionFromCause((Throwable)e);
            }
            throw this.ensureOpcUaException((Throwable)e);
        });
    }

    @Override
    public void writeValue(NodeId nodeId, Object value) throws OpcUaException {
        try {
            this.writeValueAsync(nodeId, value).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new OpcUaException(e);
        }
        catch (ExecutionException e) {
            throw this.makeOpcUaExceptionFromCause(e);
        }
    }

    @Override
    public CompletableFuture<Void> writeValueAsync(NodeId nodeId, Object value) {
        if (nodeId == null) {
            throw new IllegalArgumentException("nodeId must not be null.");
        }
        logger.debug("Writing node '{}' with value {}.", (Object)nodeId, value);
        DataValue dv = new DataValue(this.wrapVariant(value));
        return ((CompletableFuture)((CompletableFuture)this.getClient().thenCompose(client -> client.writeValue(nodeId.getInternalId(), dv))).thenAccept(status -> {
            if (!status.isGood()) {
                throw new OpcUaException("Write failed with: " + status);
            }
        })).exceptionally(e -> {
            if (e instanceof CompletionException) {
                throw this.makeOpcUaExceptionFromCause((Throwable)e);
            }
            throw this.ensureOpcUaException((Throwable)e);
        });
    }

    @Override
    public List<Object> invokeMethod(NodeId ownerId, NodeId methodId, Object ... parameters) throws OpcUaException {
        try {
            return this.invokeMethodAsync(ownerId, methodId, parameters).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new OpcUaException(e);
        }
        catch (ExecutionException e) {
            throw this.makeOpcUaExceptionFromCause(e);
        }
    }

    @Override
    public CompletableFuture<List<Object>> invokeMethodAsync(NodeId ownerId, NodeId methodId, Object ... parameters) {
        if (ownerId == null || methodId == null) {
            throw new IllegalArgumentException("ownerId and methodId must not be null.");
        }
        logger.debug("Invoking method '{}' on node '{}' with arguments {}.", new Object[]{methodId, ownerId, parameters});
        Variant[] inputs = new Variant[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            inputs[i] = this.wrapVariant(parameters[i]);
        }
        CallMethodRequest req = new CallMethodRequest(ownerId.getInternalId(), methodId.getInternalId(), inputs);
        return ((CompletableFuture)((CompletableFuture)this.getClient().thenCompose(client -> client.call(req))).thenApply(result -> {
            if (!result.getStatusCode().isGood()) {
                throw new OpcUaException("Method invocation failed with: " + result.getStatusCode());
            }
            return Arrays.stream(result.getOutputArguments()).map(this::unwrapVariant).collect(Collectors.toList());
        })).exceptionally(e -> {
            if (e instanceof CompletionException) {
                throw this.makeOpcUaExceptionFromCause((Throwable)e);
            }
            throw this.ensureOpcUaException((Throwable)e);
        });
    }

    private Variant wrapVariant(Object value) {
        return new Variant(this.mapBaSyxToMiloTypes(value));
    }

    private Object unwrapVariant(Variant variant) {
        if (variant == null || variant.getValue() == null) {
            return null;
        }
        ExpandedNodeId typeId = variant.getDataType().orElse(null);
        if (typeId == null) {
            return null;
        }
        return this.mapMiloToBaSyxTypes(variant.getValue());
    }

    private Object mapMiloToBaSyxTypes(Object value) {
        if (value instanceof DateTime) {
            long millis = ((DateTime)value).getJavaTime();
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTimeInMillis(millis);
            return xmlDatatypeFactory.newXMLGregorianCalendar(cal);
        }
        if (value instanceof UByte) {
            return new UnsignedByte((UByte)value);
        }
        if (value instanceof UShort) {
            return new UnsignedShort((UShort)value);
        }
        if (value instanceof UInteger) {
            return new UnsignedInteger((UInteger)value);
        }
        if (value instanceof ULong) {
            return new UnsignedLong((ULong)value);
        }
        return value;
    }

    private Object mapBaSyxToMiloTypes(Object value) {
        if (value instanceof XMLGregorianCalendar) {
            XMLGregorianCalendar v = (XMLGregorianCalendar)value;
            if (v.getXMLSchemaType() != DatatypeConstants.DATETIME) {
                throw new OpcUaException("The OPC UA DateTime type doesn't support incomplete date/time specifications. Illegal value: " + v);
            }
            Instant i = Instant.ofEpochMilli(v.toGregorianCalendar().getTimeInMillis());
            return new DateTime(i);
        }
        if (value instanceof UnsignedByte) {
            return ((UnsignedByte)value).getInternalValue();
        }
        if (value instanceof UnsignedShort) {
            return ((UnsignedShort)value).getInternalValue();
        }
        if (value instanceof UnsignedInteger) {
            return ((UnsignedInteger)value).getInternalValue();
        }
        if (value instanceof UnsignedLong) {
            return ((UnsignedLong)value).getInternalValue();
        }
        return value;
    }

    private OpcUaException makeOpcUaExceptionFromCause(Throwable e) {
        return this.ensureOpcUaException(e.getCause());
    }

    private OpcUaException ensureOpcUaException(Throwable e) {
        return e instanceof OpcUaException ? (OpcUaException)e : new OpcUaException(e);
    }

    static {
        try {
            xmlDatatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            logger.error("Failed to instantiate XML DatatypeFactory. This will lead to NullPointerExceptions, if DateTime values are received from the OPC UA server.", (Throwable)e);
        }
    }
}

