/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.crypto;

import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import jetbrains.exodus.util.HexUtil;
import org.jetbrains.annotations.Nullable;

public class MessageDigestUtil {
    private MessageDigestUtil() {
    }

    public static String MD5(String message) {
        return MessageDigestUtil.encode(message, "MD5", null);
    }

    public static byte[] MD5(byte[] message) {
        return MessageDigestUtil.encode(message, "MD5");
    }

    public static String sha1(String message) {
        return MessageDigestUtil.encode(message, "SHA-1", null);
    }

    public static byte[] sha1(byte[] message) {
        return MessageDigestUtil.encode(message, "SHA-1");
    }

    public static String sha256(String message) {
        return MessageDigestUtil.encode(message, "SHA-256", "UTF-8");
    }

    public static byte[] sha256(byte[] message) {
        return MessageDigestUtil.encode(message, "SHA-256");
    }

    public static String hmacSha1(byte[] key, String message) {
        return MessageDigestUtil.hmacShaX("HMACSHA1", key, message, "UTF-8");
    }

    public static byte[] hmacSha1(byte[] key, byte[] message) {
        return MessageDigestUtil.hmacShaX("HMACSHA1", key, message);
    }

    public static String hmacSha256(byte[] key, String message) {
        return MessageDigestUtil.hmacShaX("HMACSHA256", key, message, "UTF-8");
    }

    public static byte[] hmacSha256(byte[] key, byte[] message) {
        return MessageDigestUtil.hmacShaX("HMACSHA256", key, message);
    }

    private static String encode(String message, String method, @Nullable String encoding) {
        try {
            byte[] encoded = encoding != null ? message.getBytes(encoding) : message.getBytes();
            return HexUtil.byteArrayToString(MessageDigestUtil.encodeUnsafe(encoded, method));
        }
        catch (Exception e) {
            return message;
        }
    }

    private static byte[] encode(byte[] message, String method) {
        try {
            return MessageDigestUtil.encodeUnsafe(message, method);
        }
        catch (Exception e) {
            return message;
        }
    }

    private static byte[] encodeUnsafe(byte[] message, String method) throws NoSuchAlgorithmException {
        if (message == null) {
            return null;
        }
        MessageDigest md = MessageDigest.getInstance(method);
        md.update(message);
        return md.digest();
    }

    private static String hmacShaX(String method, byte[] key, String message, String encoding) {
        try {
            byte[] encoded = encoding != null ? message.getBytes(encoding) : message.getBytes();
            return HexUtil.byteArrayToString(MessageDigestUtil.hmacShaXUnsafe(method, key, encoded));
        }
        catch (Exception e) {
            return message;
        }
    }

    private static byte[] hmacShaX(String method, byte[] key, byte[] message) {
        try {
            return MessageDigestUtil.hmacShaXUnsafe(method, key, message);
        }
        catch (Exception e) {
            return message;
        }
    }

    private static byte[] hmacShaXUnsafe(String method, byte[] key, byte[] message) throws NoSuchAlgorithmException, InvalidKeyException {
        throw new UnsupportedOperationException("Is not supported as there is no javax.crypto package in MPS JDK");
    }
}

