/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support;

import de.iip_ecosphere.platform.support.OsUtils;
import de.iip_ecosphere.platform.support.commons.Commons;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class FileUtils {
    private FileUtils() {
    }

    public static File createTmpFolder(String name) {
        return FileUtils.createTmpFolder(name, false);
    }

    public static File createTmpFolder(String name, boolean cleanup) {
        String tmp = System.getProperty("java.io.tmpdir");
        File result = new File(tmp, name);
        if (result.exists() && !FileUtils.deleteQuietly(result)) {
            result = new File(tmp, name + "_" + System.currentTimeMillis());
        }
        result.mkdir();
        if (cleanup) {
            result.deleteOnExit();
        }
        return result;
    }

    public static boolean deleteQuietly(File file) {
        if (file == null) {
            return false;
        }
        try {
            if (file.isDirectory()) {
                FileUtils.cleanDirectory(file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            return file.delete();
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public static void cleanDirectory(File directory) throws IOException {
        try (Stream<Path> paths = Files.walk(directory.toPath(), new FileVisitOption[0]);){
            paths.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
    }

    public static void forceDelete(File file) throws IOException {
        Commons.getInstance().forceDelete(file);
    }

    public static void deleteOnExit(File file) {
        Commons.getInstance().deleteOnExit(file);
    }

    public static String getTempDirectoryPath() {
        return System.getProperty("java.io.tmpdir");
    }

    public static File getTempDirectory() {
        return new File(FileUtils.getTempDirectoryPath());
    }

    public static File getUserDirectory() {
        return Commons.getInstance().getUserDirectory();
    }

    public static String getUserDirectoryPath() {
        return Commons.getInstance().getUserDirectoryPath();
    }

    public static void closeQuietly(Closeable closable) {
        if (null != closable) {
            try {
                closable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void listFiles(File file, Predicate<File> accept, Consumer<File> handle) {
        if (accept.test(file)) {
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                if (null != files) {
                    for (File f : files) {
                        FileUtils.listFiles(f, accept, handle);
                    }
                }
            } else {
                handle.accept(file);
            }
        }
    }

    public static String getResolvedPath(File path, String name) {
        File f = null != name && name.length() > 0 ? new File(path, name) : path;
        try {
            return f.getCanonicalPath();
        }
        catch (IOException e) {
            return f.getAbsolutePath();
        }
    }

    public static File getResolvedFile(File path) {
        try {
            return path.getCanonicalFile();
        }
        catch (IOException e) {
            return path.getAbsoluteFile();
        }
    }

    public static String fileToBase64(File file) throws IOException {
        return Commons.getInstance().fileToBase64(file);
    }

    public static void base64ToFile(String string, File file) throws IOException {
        Commons.getInstance().base64ToFile(string, file);
    }

    public static String sanitizeFileName(String str) {
        return str.replaceAll("[^a-zA-Z0-9-_\\.]", "_");
    }

    public static String sanitizeFileName(String str, boolean addTimestamp) {
        String tmp = addTimestamp ? str + "-" + System.currentTimeMillis() : str;
        return FileUtils.sanitizeFileName(tmp);
    }

    public static File findFile(File folder, String name) {
        return Commons.getInstance().findFile(folder, name);
    }

    public static File getSystemRoot() {
        File result;
        if (OsUtils.isWindows()) {
            String sysDrive = System.getenv("SystemDrive");
            if (null == sysDrive) {
                sysDrive = "C:";
            }
            result = new File(sysDrive);
        } else {
            result = new File("/");
        }
        return result;
    }

    public static void write(File file, CharSequence data) throws IOException {
        FileUtils.write(file, data, Charset.defaultCharset());
    }

    public static void write(File file, CharSequence data, Charset charset) throws IOException {
        Commons.getInstance().write(file, data, charset);
    }

    public static String readFileToString(File file) throws IOException {
        return Commons.getInstance().readFileToString(file, Charset.defaultCharset());
    }

    public static String readFileToString(File file, Charset charset) throws IOException {
        return Commons.getInstance().readFileToString(file, charset);
    }

    public static void deleteDirectory(File directory) throws IOException {
        Commons.getInstance().deleteDirectory(directory);
    }

    public static void copyDirectory(File srcDir, File destDir, FileFilter filter) throws IOException {
        Commons.getInstance().copyDirectory(srcDir, destDir, filter);
    }

    public static void copyDirectory(File srcDir, File destDir, FileFilter filter, boolean preserveFileDate) throws IOException {
        Commons.getInstance().copyDirectory(srcDir, destDir, filter, preserveFileDate);
    }

    public static void copyDirectory(File srcDir, File destDir) throws IOException {
        Commons.getInstance().copyDirectory(srcDir, destDir);
    }

    public static void copyFile(File srcFile, File destFile) throws IOException {
        Commons.getInstance().copyFile(srcFile, destFile);
    }

    public static void writeStringToFile(File file, String data) throws IOException {
        Commons.getInstance().writeStringToFile(file, data, Charset.defaultCharset());
    }

    public static void writeStringToFile(File file, String data, Charset charset) throws IOException {
        Commons.getInstance().writeStringToFile(file, data, charset);
    }

    public static byte[] readFileToByteArray(File file) throws IOException {
        return Commons.getInstance().readFileToByteArray(file);
    }

    public static void writeByteArrayToFile(File file, byte[] data) throws IOException {
        Commons.getInstance().writeByteArrayToFile(file, data);
    }

    public static void writeByteArrayToFile(File file, byte[] data, boolean append) throws IOException {
        Commons.getInstance().writeByteArrayToFile(file, data, append);
    }

    public static void copyInputStreamToFile(InputStream source, File destination) throws IOException {
        Commons.getInstance().copyInputStreamToFile(source, destination);
    }

    public static boolean contentEquals(File file1, File file2) throws IOException {
        return Commons.getInstance().contentEquals(file1, file2);
    }

    public static long getFolderSize(File folder) {
        File[] files;
        long size = 0L;
        if (null != folder && null != (files = folder.listFiles())) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isFile()) {
                    size += files[i].length();
                    continue;
                }
                size += FileUtils.getFolderSize(files[i]);
            }
        }
        return size;
    }
}

